/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class DrawUtils {
    public static void drawTextWithBorder(PoseStack matrices, Component text, int x, int y, int borderColor, int textColor) {
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        textRenderer.m_92889_(matrices, text, (float)(x - 1), (float)y, borderColor);
        textRenderer.m_92889_(matrices, text, (float)x, (float)(y - 1), borderColor);
        textRenderer.m_92889_(matrices, text, (float)(x + 1), (float)y, borderColor);
        textRenderer.m_92889_(matrices, text, (float)x, (float)(y + 1), borderColor);
        textRenderer.m_92889_(matrices, text, (float)x, (float)y, textColor);
    }

    public static void drawItem(PoseStack matrices, int targetX, int targetY, ItemStack itemStack) {
        Minecraft.m_91087_().m_91291_().m_274569_(matrices, itemStack, targetX, targetY);
    }

    public static void drawSingleTexture(PoseStack matrices, int targetX, int targetY, int targetW, int targetH) {
        GuiComponent.m_93133_((PoseStack)matrices, (int)targetX, (int)targetY, (float)0.0f, (float)0.0f, (int)targetW, (int)targetH, (int)targetW, (int)targetH);
    }

    public static void drawSingleSprite(PoseStack matrices, int targetX, int targetY, int targetW, int targetH, TextureAtlasSprite sprite) {
        GuiComponent.m_93200_((PoseStack)matrices, (int)targetX, (int)targetY, (int)0, (int)targetW, (int)targetH, (TextureAtlasSprite)sprite);
    }

    public static void drawRepeatedTexture(PoseStack matrices, int targetX, int targetY, int targetW, int targetH, int sourceX, int sourceY, int textureW, int textureH) {
        GuiComponent.m_93133_((PoseStack)matrices, (int)targetX, (int)targetY, (float)sourceX, (float)sourceY, (int)targetW, (int)targetH, (int)textureW, (int)textureH);
    }

    public static void drawScaledTexture(PoseStack matrices, int targetX, int targetY, int targetW, int targetH, int sourceX, int sourceY, int sourceW, int sourceH, int textureW, int textureH) {
        GuiComponent.m_93160_((PoseStack)matrices, (int)targetX, (int)targetY, (int)targetW, (int)targetH, (float)sourceX, (float)sourceY, (int)sourceW, (int)sourceH, (int)textureW, (int)textureH);
    }

    public static void drawLine(PoseStack matrices, int startX, int startY, int endX, int endY, int thickness, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Vector2f tmp = new Vector2f((float)endX, (float)endY).sub((float)startX, (float)startY).normalize().perpendicular().mul((float)thickness / 2.0f);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, (float)startX + tmp.x, (float)startY + tmp.y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)startX - tmp.x, (float)startY - tmp.y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)endX - tmp.x, (float)endY - tmp.y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_252986_(matrix, (float)endX + tmp.x, (float)endY + tmp.y, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

