/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.data.ClientIconData;
import net.puffish.skillsmod.client.data.ClientSkillCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillConnectionData;
import net.puffish.skillsmod.client.data.ClientSkillData;
import net.puffish.skillsmod.client.data.ClientSkillDefinitionData;
import net.puffish.skillsmod.client.gui.DrawUtils;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.skill.SkillState;
import net.puffish.skillsmod.utils.Bounds2i;
import org.joml.Vector2i;

public class SkillsScreen
extends Screen {
    private static final ResourceLocation TABS_TEXTURE = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final ResourceLocation WINDOW_TEXTURE = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("textures/gui/advancements/widgets.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private final List<ClientSkillCategoryData> categories;
    private int activeCategory = 0;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private float scale = 1.0f;
    private int x = 0;
    private int y = 0;
    private boolean dragging;
    private Bounds2i bounds;
    private double dragStartX;
    private double dragStartY;
    private boolean small;
    private int contentPaddingTop;
    private int contentPaddingLeft;
    private int contentPaddingRight;
    private int contentPaddingBottom;

    public SkillsScreen(List<ClientSkillCategoryData> categories) {
        super(CommonComponents.f_237098_);
        this.categories = categories;
    }

    private ClientSkillCategoryData getActiveCategory() {
        return this.categories.get(this.activeCategory);
    }

    private void setActiveCategory(int activeCategory) {
        this.activeCategory = activeCategory;
        this.resize();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.resize();
    }

    private void resize() {
        boolean bl = this.small = this.f_96543_ < 450;
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        this.x = this.f_96543_ / 2;
        this.y = this.f_96544_ / 2;
        this.bounds = this.getActiveCategory().getBounds();
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - this.x, this.contentPaddingTop - this.y));
        this.bounds.extend(new Vector2i(this.f_96543_ - this.x - this.contentPaddingRight, this.f_96544_ - this.y - this.contentPaddingBottom));
        int contentWidth = this.f_96543_ - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.f_96544_ - this.contentPaddingTop - this.contentPaddingBottom;
        int halfWidth = Mth.m_184652_((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfHeight = Mth.m_184652_((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vector2i(-halfWidth, -halfHeight));
        this.bounds.extend(new Vector2i(halfWidth, halfHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.scale = 1.0f;
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)Math.round((mouseX - (double)this.x) / (double)this.scale), (int)Math.round((mouseY - (double)this.y) / (double)this.scale));
    }

    private boolean isInsideTab(Vector2i mouse, int i) {
        return mouse.x >= 8 + i * 32 && mouse.y >= 8 && mouse.x < 8 + i * 32 + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillData skill) {
        return transformedMouse.x >= skill.getX() - 13 && transformedMouse.y >= skill.getY() - 13 && transformedMouse.x < skill.getX() + 13 && transformedMouse.y < skill.getY() + 13;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.f_96543_ - this.contentPaddingRight && mouse.y < this.f_96544_ - this.contentPaddingBottom;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
                if (!this.isInsideSkill(transformedMouse, skill)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(SkillClickOutPacket.write(this.getActiveCategory().getId(), skill.getId()));
            }
            if (button == 0) {
                this.dragStartX = mouseX - (double)this.x;
                this.dragStartY = mouseY - (double)this.y;
                this.dragging = true;
            }
        } else {
            this.dragging = false;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.isInsideTab(mouse, i)) continue;
            this.setActiveCategory(i);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.drawContent(matrices, mouseX, mouseY);
        this.drawWindow(matrices);
        this.drawTabs(matrices, mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.x = (int)Math.round(mouseX - this.dragStartX);
            this.y = (int)Math.round(mouseY - this.dragStartY);
            this.limitPosition();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        float factor = (float)Math.pow(2.0, amount * 0.25);
        this.scale *= factor;
        if (this.scale < this.minScale) {
            this.scale = this.minScale;
            factor = this.minScale / this.scale;
        }
        if (this.scale > this.maxScale) {
            this.scale = this.maxScale;
            factor = this.maxScale / this.scale;
        }
        this.x = (int)((long)this.x - Math.round((double)(factor - 1.0f) * (mouseX - (double)this.x)));
        this.y = (int)((long)this.y - Math.round((double)(factor - 1.0f) * (mouseY - (double)this.y)));
        this.limitPosition();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void limitPosition() {
        this.y = Math.min(this.y, Math.round((float)this.contentPaddingTop - (float)this.bounds.min().y() * this.scale));
        this.x = Math.min(this.x, Math.round((float)this.contentPaddingLeft - (float)this.bounds.min().x() * this.scale));
        this.x = Math.max(this.x, Math.round((float)(this.f_96543_ - this.contentPaddingRight) - (float)this.bounds.max().x() * this.scale));
        this.y = Math.max(this.y, Math.round((float)(this.f_96544_ - this.contentPaddingBottom) - (float)this.bounds.max().y() * this.scale));
    }

    private void drawIcon(PoseStack matrices, int x, int y, ClientIconData icon) {
        if (this.f_96541_ == null) {
            return;
        }
        if (icon instanceof ClientIconData.ItemIconData) {
            ClientIconData.ItemIconData itemIcon = (ClientIconData.ItemIconData)icon;
            DrawUtils.drawItem(matrices, x - 8, y - 8, itemIcon.getItem());
        } else if (icon instanceof ClientIconData.EffectIconData) {
            ClientIconData.EffectIconData effectIcon = (ClientIconData.EffectIconData)icon;
            TextureAtlasSprite sprite = this.f_96541_.m_91306_().m_118732_(effectIcon.getEffect());
            RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_247685_());
            DrawUtils.drawSingleSprite(matrices, x - 9, y - 9, 18, 18, sprite);
        } else if (icon instanceof ClientIconData.TextureIconData) {
            ClientIconData.TextureIconData textureIcon = (ClientIconData.TextureIconData)icon;
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureIcon.getTexture());
            DrawUtils.drawSingleTexture(matrices, x - 8, y - 8, 16, 16);
        }
    }

    private void drawContent(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)519);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 256.0f);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
        matrices.m_252880_(0.0f, 0.0f, -512.0f);
        GuiComponent.m_93172_((PoseStack)matrices, (int)(this.contentPaddingLeft - 4), (int)(this.contentPaddingTop - 4), (int)(this.f_96543_ - this.contentPaddingRight + 4), (int)(this.f_96544_ - this.contentPaddingBottom + 4), (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        matrices.m_252880_((float)this.x, (float)this.y, 128.0f);
        matrices.m_85841_(this.scale, this.scale, 1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getActiveCategory().getBackground());
        DrawUtils.drawRepeatedTexture(matrices, this.bounds.min().x(), this.bounds.min().y(), this.bounds.width(), this.bounds.height(), 0, 0, 16, 16);
        for (ClientSkillConnectionData connections : this.getActiveCategory().getConnections()) {
            ClientSkillData skillA = this.getActiveCategory().getSkills().get(connections.getSkillAId());
            ClientSkillData skillB = this.getActiveCategory().getSkills().get(connections.getSkillBId());
            if (skillA == null || skillB == null) continue;
            DrawUtils.drawLine(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), 3, -16777216);
            DrawUtils.drawLine(matrices, skillA.getX(), skillA.getY(), skillB.getX(), skillB.getY(), 1, -1);
        }
        for (ClientSkillData skill : this.getActiveCategory().getSkills().values()) {
            AdvancementWidgetType status;
            ClientSkillDefinitionData definition = this.getActiveCategory().getDefinitions().get(skill.getDefinitionId());
            if (definition == null) continue;
            AdvancementWidgetType advancementWidgetType = status = skill.getState() == SkillState.UNLOCKED ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            if (skill.getState() == SkillState.LOCKED) {
                RenderSystem.m_157429_((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_TEXTURE);
            SkillsScreen.m_93228_((PoseStack)matrices, (int)(skill.getX() - 13), (int)(skill.getY() - 13), (int)definition.getFrame().m_15551_(), (int)(128 + status.m_97325_() * 26), (int)26, (int)26);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawIcon(matrices, skill.getX(), skill.getY(), definition.getIcon());
            if (!this.isInsideSkill(transformedMouse, skill) || !this.isInsideContent(mouse)) continue;
            this.m_257959_(Stream.concat(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)definition.getTitle()).stream(), Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)definition.getDescription()).stream()).toList());
        }
        matrices.m_85849_();
        matrices.m_85836_();
        RenderSystem.m_69456_((int)519);
        matrices.m_252880_(0.0f, 0.0f, -512.0f);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GuiComponent.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69456_((int)515);
        matrices.m_85849_();
    }

    private void drawTabs(PoseStack matrices, double mouseX, double mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TABS_TEXTURE);
        for (int i = 0; i < this.categories.size(); ++i) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)(8 + 32 * i), (int)8, (float)(i > 0 ? 28.0f : 0.0f), (float)(this.activeCategory == i ? 32.0f : 0.0f), (int)28, (int)32, (int)256, (int)256);
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        for (int i = 0; i < this.categories.size(); ++i) {
            ClientSkillCategoryData category = this.categories.get(i);
            this.drawIcon(matrices, 8 + 32 * i + 6 + 8, 25, category.getIcon());
            if (!this.isInsideTab(mouse, i)) continue;
            this.m_257959_(Tooltip.m_257868_((Minecraft)this.f_96541_, (Component)category.getTitle()));
        }
    }

    private void drawWindow(PoseStack matrices) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69465_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW_TEXTURE);
        GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)(this.f_96544_ - 8 - 70 + 1), (float)0.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)(this.f_96544_ - 8 - 70 + 1), (float)126.0f, (float)70.0f, (int)126, (int)70, (int)256, (int)256);
        DrawUtils.drawScaledTexture(matrices, 8, 78, 126, this.f_96544_ - 16 - 140 + 1, 0, 69, 126, 2, 256, 256);
        DrawUtils.drawScaledTexture(matrices, 134, this.f_96544_ - 8 - 70 + 1, this.f_96543_ - 16 - 252 + 1, 70, 125, 70, 2, 70, 256, 256);
        DrawUtils.drawScaledTexture(matrices, this.f_96543_ - 8 - 126 + 1, 78, 126, this.f_96544_ - 16 - 140 + 1, 126, 69, 126, 2, 256, 256);
        if (this.small) {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)52, (float)0.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)16, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)52, (float)126.0f, (float)8.0f, (int)126, (int)26, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.f_96543_ - 16 - 252 + 1, 16, 125, 0, 2, 16, 256, 256);
            DrawUtils.drawScaledTexture(matrices, 134, 52, this.f_96543_ - 16 - 252 + 1, 54, 125, 8, 2, 54, 256, 256);
        } else {
            GuiComponent.m_93133_((PoseStack)matrices, (int)8, (int)36, (float)0.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrices, (int)(this.f_96543_ - 8 - 126 + 1), (int)36, (float)126.0f, (float)0.0f, (int)126, (int)42, (int)256, (int)256);
            DrawUtils.drawScaledTexture(matrices, 134, 36, this.f_96543_ - 16 - 252 + 1, 70, 125, 0, 2, 70, 256, 256);
        }
        MutableComponent tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)tmpX, (float)tmpY, -12566464);
        int leftX = tmpX + this.f_96547_.m_92852_((FormattedText)tmpText);
        tmpX = this.f_96543_ - 8 - 7;
        tmpText = Component.m_237113_((String)Integer.toString(this.getActiveCategory().getPointsLeft()));
        tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText);
        DrawUtils.drawTextWithBorder(matrices, (Component)tmpText, --tmpX, tmpY, -16777216, -8323296);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        this.f_96547_.m_92889_(matrices, (Component)tmpText, (float)(tmpX -= this.f_96547_.m_92852_((FormattedText)tmpText)), (float)tmpY, -12566464);
        int rightX = tmpX;
        if (this.getActiveCategory().getExperienceProgress() >= 0.0f) {
            if (this.small) {
                tmpX = this.f_96543_ - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (leftX + rightX - 182) / 2;
                tmpY = 43;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
            SkillsScreen.m_93228_((PoseStack)matrices, (int)tmpX, (int)tmpY, (int)0, (int)64, (int)182, (int)5);
            int width = Math.min(182, (int)(this.getActiveCategory().getExperienceProgress() * 183.0f));
            if (width > 0) {
                SkillsScreen.m_93228_((PoseStack)matrices, (int)tmpX, (int)tmpY, (int)0, (int)69, (int)width, (int)5);
            }
        }
    }
}

