/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class IconConfig {
    private final String type;
    private final JsonElement data;

    private IconConfig(String type, JsonElement data) {
        this.type = type;
        this.data = data;
    }

    public static Result<IconConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(IconConfig::parse);
    }

    public static Result<IconConfig, Error> parse(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<String> type = rootObject.getString("type").ifFailure(errors::add).getSuccess();
        Optional<JsonElementWrapper> data = rootObject.get("data").ifFailure(errors::add).getSuccess();
        if (errors.isEmpty()) {
            return Result.success(new IconConfig(type.orElseThrow(), data.orElseThrow().getJson()));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public String getType() {
        return this.type;
    }

    public JsonElement getData() {
        return this.data;
    }
}

