/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.experience.ExperienceSource;
import net.puffish.skillsmod.experience.ExperienceSourceRegistry;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class ExperienceSourceConfig {
    private final ResourceLocation type;
    private final ExperienceSource instance;

    private ExperienceSourceConfig(ResourceLocation type, ExperienceSource instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<ExperienceSourceConfig, Error> parse(JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(ExperienceSourceConfig::parse);
    }

    public static Result<ExperienceSourceConfig, Error> parse(JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional<JsonElementWrapper> optTypeElement = rootObject.get("type").ifFailure(errors::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> JsonParseUtils.parseIdentifier(typeElement).ifFailure(errors::add).getSuccess());
        Result<JsonElementWrapper, Error> maybeDataElement = rootObject.get("data");
        if (errors.isEmpty()) {
            return ExperienceSourceConfig.build((ResourceLocation)optType.orElseThrow(), maybeDataElement, optTypeElement.orElseThrow().getPath());
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    private static Result<ExperienceSourceConfig, Error> build(ResourceLocation type, Result<JsonElementWrapper, Error> maybeDataElement, JsonPath typeElementPath) {
        return ExperienceSourceRegistry.getFactory(type).map(factory -> factory.create(maybeDataElement).mapSuccess(instance -> new ExperienceSourceConfig(type, (ExperienceSource)instance))).orElseGet(() -> Result.failure(typeElementPath.errorAt("Expected a valid source type")));
    }

    public void dispose(MinecraftServer server) {
        this.instance.dispose(server);
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public ExperienceSource getInstance() {
        return this.instance;
    }
}

