/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.JsonParseUtils;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class SkillDefinitionConfig {
    private final String id;
    private final Component title;
    private final Component description;
    private final IconConfig icon;
    private final FrameType frame;
    private final List<SkillRewardConfig> rewards;

    private SkillDefinitionConfig(String id, Component title, Component description, IconConfig icon, FrameType frame, List<SkillRewardConfig> rewards) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.frame = frame;
        this.rewards = rewards;
    }

    public static Result<SkillDefinitionConfig, Error> parse(String id, JsonElementWrapper rootElement) {
        return rootElement.getAsObject().andThen(rootObject -> SkillDefinitionConfig.parse(id, rootObject));
    }

    public static Result<SkillDefinitionConfig, Error> parse(String id, JsonObjectWrapper rootObject) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Optional optTitle = rootObject.get("title").andThen(JsonParseUtils::parseText).ifFailure(errors::add).getSuccess();
        Component optDescription = rootObject.get("description").getSuccess().flatMap(descriptionElement -> JsonParseUtils.parseText(descriptionElement).ifFailure(errors::add).getSuccess()).orElseGet(Component::m_237119_);
        Optional optIcon = rootObject.get("icon").andThen(IconConfig::parse).ifFailure(errors::add).getSuccess();
        FrameType frame = rootObject.get("frame").getSuccess().flatMap(frameElement -> JsonParseUtils.parseFrame(frameElement).ifFailure(errors::add).getSuccess()).orElse(FrameType.TASK);
        List rewards = rootObject.getArray("rewards").andThen(array -> array.getAsList((i, element) -> SkillRewardConfig.parse(element)).mapFailure(ManyErrors::ofList)).ifFailure(errors::add).getSuccess().orElseGet(List::of);
        if (errors.isEmpty()) {
            return Result.success(new SkillDefinitionConfig(id, (Component)optTitle.orElseThrow(), optDescription, (IconConfig)optIcon.orElseThrow(), frame, rewards));
        }
        return Result.failure(ManyErrors.ofList(errors));
    }

    public void dispose(MinecraftServer server) {
        for (SkillRewardConfig reward : this.rewards) {
            reward.dispose(server);
        }
    }

    public String getId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public FrameType getFrame() {
        return this.frame;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public List<SkillRewardConfig> getRewards() {
        return this.rewards;
    }
}

