/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.ManyErrors;

public class SkillsConfig {
    private final Map<String, SkillConfig> skills;

    private SkillsConfig(Map<String, SkillConfig> skills) {
        this.skills = skills;
    }

    public static Result<SkillsConfig, Error> parse(JsonElementWrapper rootElement, SkillDefinitionsConfig definitions) {
        return rootElement.getAsObject().andThen(rootObject -> SkillsConfig.parse(rootObject, definitions));
    }

    public static Result<SkillsConfig, Error> parse(JsonObjectWrapper rootObject, SkillDefinitionsConfig definitions) {
        return rootObject.getAsMap((key, value) -> SkillConfig.parse(key, value, definitions)).mapFailure(errors -> ManyErrors.ofList(errors)).mapSuccess(SkillsConfig::new);
    }

    public Optional<SkillConfig> getById(String id) {
        return Optional.ofNullable(this.skills.get(id));
    }

    public Collection<SkillConfig> getAll() {
        return this.skills.values();
    }
}

