/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.Path;
import net.puffish.skillsmod.json.JsonArrayWrapper;
import net.puffish.skillsmod.json.JsonObjectWrapper;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.json.JsonWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;
import net.puffish.skillsmod.utils.error.SingleError;

public class JsonElementWrapper
extends JsonWrapper {
    private final JsonElement json;

    public JsonElementWrapper(JsonElement json, JsonPath path) {
        super(path);
        this.json = json;
    }

    public static Result<JsonElementWrapper, Error> parseString(String json) {
        try {
            return Result.success(new JsonElementWrapper(JsonParser.parseString((String)json), JsonPath.createAnonymous()));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Could not read json"));
        }
    }

    public static Result<JsonElementWrapper, Error> parseFile(Path filePath, Path jsonPath) {
        String name = filePath.getFileName().toString();
        try {
            return Result.success(new JsonElementWrapper(JsonParser.parseString((String)Files.readString(filePath)), JsonPath.fromPath(jsonPath)));
        }
        catch (Exception e) {
            return Result.failure(SingleError.of("Could not read file " + name));
        }
    }

    public Result<JsonObjectWrapper, Error> getAsObject() {
        try {
            return Result.success(new JsonObjectWrapper(this.json.getAsJsonObject(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an object"));
        }
    }

    public Result<JsonArrayWrapper, Error> getAsArray() {
        try {
            return Result.success(new JsonArrayWrapper(this.json.getAsJsonArray(), this.path));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an array"));
        }
    }

    public Result<String, Error> getAsString() {
        try {
            return Result.success(this.json.getAsString());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a string"));
        }
    }

    public Result<Float, Error> getAsFloat() {
        try {
            return Result.success(Float.valueOf(this.json.getAsFloat()));
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a float"));
        }
    }

    public Result<Integer, Error> getAsInt() {
        try {
            return Result.success(this.json.getAsInt());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("an int"));
        }
    }

    public Result<Boolean, Error> getAsBoolean() {
        try {
            return Result.success(this.json.getAsBoolean());
        }
        catch (Exception e) {
            return Result.failure(this.path.expectedToBe("a boolean"));
        }
    }

    public JsonElement getJson() {
        return this.json;
    }
}

