/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.puffish.skillsmod.json.JsonArrayWrapper;
import net.puffish.skillsmod.json.JsonElementWrapper;
import net.puffish.skillsmod.json.JsonMapReader;
import net.puffish.skillsmod.json.JsonPath;
import net.puffish.skillsmod.json.JsonWrapper;
import net.puffish.skillsmod.utils.Result;
import net.puffish.skillsmod.utils.error.Error;

public class JsonObjectWrapper
extends JsonWrapper {
    private final JsonObject json;

    public JsonObjectWrapper(JsonObject json, JsonPath path) {
        super(path);
        this.json = json;
    }

    public Result<JsonElementWrapper, Error> get(String key) {
        JsonPath newPath = this.path.thenObject(key);
        JsonElement element = this.json.get(key);
        if (element == null) {
            return Result.failure(newPath.expectedToExist());
        }
        return Result.success(new JsonElementWrapper(element, newPath));
    }

    public Result<JsonObjectWrapper, Error> getObject(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an object")).andThen(JsonElementWrapper::getAsObject);
    }

    public Result<JsonArrayWrapper, Error> getArray(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an array")).andThen(JsonElementWrapper::getAsArray);
    }

    public Result<String, Error> getString(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a string")).andThen(JsonElementWrapper::getAsString);
    }

    public Result<Float, Error> getFloat(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a float")).andThen(JsonElementWrapper::getAsFloat);
    }

    public Result<Integer, Error> getInt(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("an int")).andThen(JsonElementWrapper::getAsInt);
    }

    public Result<Boolean, Error> getBoolean(String key) {
        return this.get(key).mapFailure(e -> this.path.thenObject(key).expectedToExistAndBe("a boolean")).andThen(JsonElementWrapper::getAsBoolean);
    }

    public Stream<Map.Entry<String, JsonElementWrapper>> stream() {
        return this.json.asMap().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new JsonElementWrapper((JsonElement)entry.getValue(), this.path.thenObject((String)entry.getKey()))));
    }

    public <S, F> Result<Map<String, S>, List<F>> getAsMap(JsonMapReader<S, F> reader) {
        ArrayList exceptions = new ArrayList();
        HashMap map = new HashMap();
        this.json.asMap().forEach((key, value) -> ((Result)reader.apply(key, new JsonElementWrapper((JsonElement)value, this.path.thenObject((String)key)))).peek(t -> map.put(key, t), exceptions::add));
        if (exceptions.isEmpty()) {
            return Result.success(map);
        }
        return Result.failure(exceptions);
    }

    public JsonObject getJson() {
        return this.json;
    }
}

