/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.puffish.skillsmod.SkillsAPI;
import net.puffish.skillsmod.access.EntityAttributeInstanceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.attributes.PlayerAttributes;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (source.m_276093_(DamageTypes.f_268534_)) {
                attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.RANGED_DAMAGE);
                damage = (float)attribute.computeValueForInitial(damage);
            } else {
                attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.MELEE_DAMAGE);
                damage = (float)attribute.computeValueForInitial(damage);
            }
        }
        return damage;
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.HEALING);
            amount = (float)attribute.computeValueForInitial(amount);
        }
        return amount;
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectAtGetJumpVelocity(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.JUMP);
            cir.setReturnValue((Object)Float.valueOf((float)attribute.computeValueForInitial(cir.getReturnValueF())));
        }
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.JUMP);
            reduction = (float)((double)reduction + (attribute.computeValueForInitial(1.0) - 1.0) * 10.0);
        }
        return reduction;
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    private void injectAtDrop(DamageSource source, CallbackInfo ci) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity entity2 = (LivingEntity)this;
            if (entity2.m_6149_()) {
                WorldChunkAccess worldChunk = (WorldChunkAccess)entity2.m_9236_().m_46745_(entity2.m_20183_());
                worldChunk.antiFarmingCleanupOutdated();
                SkillsAPI.visitExperienceSources(player, experienceSource -> {
                    KillEntityExperienceSource entityExperienceSource;
                    if (experienceSource instanceof KillEntityExperienceSource && worldChunk.antiFarmingAddAndCheck((entityExperienceSource = (KillEntityExperienceSource)experienceSource).getAntiFarming())) {
                        return entityExperienceSource.getValue(entity2.m_6095_(), entity2.m_213860_());
                    }
                    return 0;
                });
            }
        }
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectAtModifyAppliedDamage(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (cir.getReturnValueF() < 1.1342745E38f) {
                EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(PlayerAttributes.RESISTANCE);
                cir.setReturnValue((Object)Float.valueOf(Math.max(0.0f, 2.0f * cir.getReturnValueF() - (float)attribute.computeValueForInitial(cir.getReturnValueF()))));
            }
        }
    }
}

