/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.puffish.skillsmod.config.experience.ExperienceConfig;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private boolean unlocked;
    private int points;
    private int experience;

    private CategoryData(Set<String> unlockedSkills, boolean unlocked, int points, int experience) {
        this.unlockedSkills = unlockedSkills;
        this.unlocked = unlocked;
        this.points = points;
        this.experience = experience;
    }

    public static CategoryData create(boolean unlocked) {
        return new CategoryData(new HashSet<String>(), unlocked, 0, 0);
    }

    public static CategoryData read(CompoundTag nbt) {
        boolean unlocked = nbt.m_128471_("unlocked");
        int points = nbt.m_128451_("points");
        int experience = nbt.m_128451_("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        ListTag unlockedNbt = nbt.m_128437_("unlocked_skills", 8);
        for (Tag elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof StringTag)) continue;
            StringTag stringNbt = (StringTag)elementNbt;
            unlockedSkills.add(stringNbt.m_7916_());
        }
        return new CategoryData(unlockedSkills, unlocked, points, experience);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.m_128379_("unlocked", this.unlocked);
        nbt.m_128405_("points", this.points);
        nbt.m_128405_("experience", this.experience);
        ListTag unlockedNbt = new ListTag();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)StringTag.m_129297_((String)skill));
        }
        nbt.m_128365_("unlocked_skills", (Tag)unlockedNbt);
        return nbt;
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public void addExperience(int experience) {
        this.experience += experience;
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public int getPointsForExperience(ExperienceConfig experience) {
        if (!experience.isEnabled()) {
            return 0;
        }
        return experience.getLevel(this);
    }

    public int getSpentPoints() {
        return this.getUnlockedSkillIds().size();
    }

    public int getPointsLeft(ExperienceConfig experience) {
        return this.getExtraPoints() + this.getPointsForExperience(experience) - this.getSpentPoints();
    }

    public void setPointsLeft(int count, ExperienceConfig experience) {
        this.addExtraPoints(count - this.getPointsLeft(experience));
    }

    public void addExtraPoints(int count) {
        this.points += count;
    }

    public int getExtraPoints() {
        return this.points;
    }

    public void setExtraPoints(int points) {
        this.points = points;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
    }
}

