/*
 * Decompiled with CFR 0.152.
 */
package com.Ultramega.ShowcaseItem.mixin.client;

import com.Ultramega.ShowcaseItem.ShowcaseItemFeature;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Accessor
    public abstract ItemColors getItemColors();

    @Inject(method={"renderQuadList"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderQuadList(MatrixStack ms, IVertexBuilder builder, List<BakedQuad> quads, ItemStack stack, int lightmap, int overlay, CallbackInfo ci) {
        if (ShowcaseItemFeature.alphaValue != 1.0f) {
            boolean flag = !stack.func_190926_b();
            MatrixStack.Entry entry = ms.func_227866_c_();
            for (BakedQuad bakedquad : quads) {
                int i = flag && bakedquad.func_178212_b() ? this.getItemColors().func_186728_a(stack, bakedquad.func_178211_c()) : -1;
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                builder.addVertexData(entry, bakedquad, r, g, b, ShowcaseItemFeature.alphaValue, lightmap, overlay, true);
            }
            ci.cancel();
        }
    }
}

