/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.capability.ISpellHolder;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.network.SpellsSyncMessage;
import de.cas_ual_ty.spells.spell.IEquipSpell;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class SpellHolder
implements ISpellHolder {
    public static final int SPELL_SLOTS = 5;
    public static final String EMPTY_SLOT = "";
    protected final ISpell[] slots = new ISpell[5];
    protected final Player player;

    public SpellHolder(Player player) {
        this.player = player;
    }

    @Override
    public int getSlots() {
        return 5;
    }

    @Override
    public ISpell getSpell(int slot) {
        return this.slots[slot];
    }

    @Override
    public void setSpell(int slot, @Nullable ISpell spell) {
        IEquipSpell equipSpell;
        ISpell iSpell = this.slots[slot];
        if (iSpell instanceof IEquipSpell) {
            equipSpell = (IEquipSpell)iSpell;
            equipSpell.onUnequip(this, slot);
        }
        if (spell instanceof IEquipSpell) {
            equipSpell = (IEquipSpell)spell;
            equipSpell.onEquip(this, slot);
        }
        this.slots[slot] = spell;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public int getAmountSpellEquipped(ISpell spell) {
        int amount = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.getSpell(i) != spell) continue;
            ++amount;
        }
        return amount;
    }

    public void clear() {
        for (int i = 0; i < 5; ++i) {
            this.removeSpell(i);
        }
    }

    public SpellsSyncMessage makeSyncMessage() {
        return new SpellsSyncMessage(this.player.m_142049_(), this.slots);
    }

    public ListTag serializeNBT() {
        ListTag tag = new ListTag();
        for (int i = 0; i < 5; ++i) {
            ISpell spell = this.getSpell(i);
            if (spell != null) {
                tag.add(i, (Tag)StringTag.m_129297_((String)spell.getRegistryName().toString()));
                continue;
            }
            tag.add(i, (Tag)StringTag.m_129297_((String)EMPTY_SLOT));
        }
        return tag;
    }

    public void deserializeNBT(ListTag tag) {
        for (int i = 0; i < 5 && i < tag.size(); ++i) {
            String key;
            if (tag.get(i).m_7060_() != 8 || (key = tag.m_128778_(i)).equals(EMPTY_SLOT)) continue;
            this.slots[i] = SpellsUtil.getSpell(new ResourceLocation(key));
        }
    }

    @Override
    public void sendSync() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SpellsAndShields.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)this.makeSyncMessage());
        }
    }

    public static LazyOptional<SpellHolder> getSpellHolder(Player player) {
        return player.getCapability(SpellsCapabilities.SPELLS_CAPABILITY).cast();
    }
}

