/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.capability.IManaHolder;
import de.cas_ual_ty.spells.capability.ISpellDataHolder;
import de.cas_ual_ty.spells.capability.ISpellHolder;
import de.cas_ual_ty.spells.capability.ISpellProgressionHolder;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.SpellDataHolder;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;

public class SpellsCapabilities {
    public static Capability<IManaHolder> MANA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IManaHolder>(){});
    public static Capability<ISpellHolder> SPELLS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpellHolder>(){});
    public static Capability<ISpellProgressionHolder> SPELL_PROGRESSION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpellProgressionHolder>(){});
    public static Capability<ISpellDataHolder> SPELL_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpellDataHolder>(){});

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IManaHolder.class);
        event.register(ISpellHolder.class);
        event.register(ISpellProgressionHolder.class);
        event.register(ISpellDataHolder.class);
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object manaHolder;
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            manaHolder = new ManaHolder((LivingEntity)player);
            SpellsCapabilities.attachCapability(event, manaHolder, MANA_CAPABILITY, "mana_holder");
            SpellHolder spellHolder = new SpellHolder(player);
            SpellsCapabilities.attachCapability(event, spellHolder, SPELLS_CAPABILITY, "spell_holder");
            SpellProgressionHolder spellProgressionHolder = new SpellProgressionHolder(player);
            SpellsCapabilities.attachCapability(event, spellProgressionHolder, SPELL_PROGRESSION_CAPABILITY, "spell_progression_holder");
        }
        if ((manaHolder = event.getObject()) instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)manaHolder;
            SpellDataHolder spellDataHolder = new SpellDataHolder(entity);
            SpellsCapabilities.attachCapability(event, spellDataHolder, SPELL_DATA_CAPABILITY, "spell_data_holder");
        }
    }

    private static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        if (!event.isWasDeath()) {
            SpellProgressionHolder.getSpellProgressionHolder(event.getPlayer()).ifPresent(current -> SpellProgressionHolder.getSpellProgressionHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
            ManaHolder.getManaHolder((LivingEntity)event.getPlayer()).ifPresent(current -> {
                ManaHolder.getManaHolder((LivingEntity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                current.sendSync();
            });
            SpellHolder.getSpellHolder(event.getPlayer()).ifPresent(current -> {
                SpellHolder.getSpellHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                current.sendSync();
            });
            SpellDataHolder.getSpellDataHolder((LivingEntity)event.getPlayer()).ifPresent(current -> SpellDataHolder.getSpellDataHolder((LivingEntity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
        } else {
            SpellProgressionHolder.getSpellProgressionHolder(event.getPlayer()).ifPresent(current -> {
                SpellProgressionHolder.getSpellProgressionHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                if (((Boolean)SpellsConfig.FORGET_SPELLS_ON_DEATH.get()).booleanValue()) {
                    for (ISpell key : ((HashMap)current.getProgression()).keySet()) {
                        if (current.getSpellStatus(key) != SpellStatus.LEARNED) continue;
                        current.setSpellStatus(key, SpellStatus.FORGOTTEN);
                    }
                }
            });
            if (!((Boolean)SpellsConfig.CLEAR_SLOTS_ON_DEATH.get()).booleanValue() && !((Boolean)SpellsConfig.FORGET_SPELLS_ON_DEATH.get()).booleanValue()) {
                SpellHolder.getSpellHolder(event.getPlayer()).ifPresent(current -> {
                    SpellHolder.getSpellHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                    current.sendSync();
                });
            }
            ManaHolder.getManaHolder((LivingEntity)event.getPlayer()).ifPresent(manaHolder -> {
                if (((Boolean)SpellsConfig.RESPAWN_WITH_FULL_MANA.get()).booleanValue()) {
                    manaHolder.replenish(manaHolder.getMaxMana());
                }
                manaHolder.sendSync();
            });
        }
        event.getOriginal().invalidateCaps();
    }

    private static <T extends Tag, C extends INBTSerializable<T>> void attachCapability(AttachCapabilitiesEvent<?> event, final C capData, final Capability<C> capability, String name) {
        final LazyOptional optional = LazyOptional.of(() -> capData);
        ICapabilitySerializable provider = new ICapabilitySerializable<T>(){

            public <S> LazyOptional<S> getCapability(Capability<S> cap, Direction side) {
                if (cap == capability) {
                    return optional.cast();
                }
                return LazyOptional.empty();
            }

            public T serializeNBT() {
                return capData.serializeNBT();
            }

            public void deserializeNBT(T tag) {
                capData.deserializeNBT(tag);
            }
        };
        event.addCapability(new ResourceLocation("spells_and_shields", name), (ICapabilityProvider)provider);
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void playerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void startTracking(PlayerEvent.StartTracking event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)player;
                ManaHolder.getManaHolder(livingEntity).ifPresent(manaHolder -> SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)manaHolder.makeSyncMessage()));
                if (livingEntity instanceof Player) {
                    Player target = (Player)livingEntity;
                    SpellHolder.getSpellHolder(target).ifPresent(spellHolder -> SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)spellHolder.makeSyncMessage()));
                }
            }
        }
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_) {
            ManaHolder.getManaHolder((LivingEntity)event.player).ifPresent(ManaHolder::tick);
        }
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        SpellDataHolder.getSpellDataHolder(event.getEntityLiving()).ifPresent(SpellDataHolder::tick);
    }

    public static void registerEvents() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsCapabilities::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, SpellsCapabilities::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerClone);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerChangedDimensions);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::startTracking);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerTick);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::livingTick);
    }
}

