/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import com.mojang.blaze3d.platform.InputConstants;
import de.cas_ual_ty.spells.util.SpellHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class SpellKeyBindings {
    public static final String CATEGORY = "key.spells_and_shields.categories.spell_slots";
    public static final int COOLDOWN = 10;
    public static KeyMapping[] slotKeys;
    public static int[] cooldowns;

    public static void clientSetup(FMLClientSetupEvent event) {
        slotKeys = new KeyMapping[5];
        cooldowns = new int[5];
        for (int i = 0; i < slotKeys.length; ++i) {
            SpellKeyBindings.slotKeys[i] = new KeyMapping(SpellKeyBindings.key(i), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, CATEGORY);
            ClientRegistry.registerKeyBinding((KeyMapping)slotKeys[i]);
        }
    }

    public static String key(int slot) {
        return "key.spells_and_shields.key.slot_" + (slot + 1);
    }

    public static MutableComponent getBaseTooltip() {
        return new TranslatableComponent("controls.keybinds.title");
    }

    public static MutableComponent getTooltip(int slot) {
        return new TextComponent(slotKeys[slot].m_90863_().getString());
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.phase == TickEvent.Phase.END && player != null) {
            for (int i = 0; i < slotKeys.length; ++i) {
                if (cooldowns[i] > 0) {
                    int n = i;
                    cooldowns[n] = cooldowns[n] - 1;
                    continue;
                }
                if (!slotKeys[i].m_90857_()) continue;
                SpellHelper.fireSpellSlot((Player)player, i);
                SpellKeyBindings.cooldowns[i] = 10;
            }
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(SpellKeyBindings::clientTick);
    }
}

