/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client.progression;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.client.progression.SelectedSpellWidget;
import de.cas_ual_ty.spells.client.progression.SpellInteractButton;
import de.cas_ual_ty.spells.client.progression.SpellNodeWidget;
import de.cas_ual_ty.spells.client.progression.SpellSlotWidget;
import de.cas_ual_ty.spells.client.progression.SpellTreeTab;
import de.cas_ual_ty.spells.network.RequestEquipSpellMessage;
import de.cas_ual_ty.spells.network.RequestLearnSpellMessage;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.PacketDistributor;

public class SpellProgressionScreen
extends AbstractContainerScreen<SpellProgressionMenu> {
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation TABS_LOCATION = new ResourceLocation("textures/gui/advancements/tabs.png");
    public static final String KEY_LEARN = "spell_progression.learn";
    public static final String KEY_EQUIP = "spell_progression.equip";
    public static final String KEY_UNAVAILABLE = "spell_progression.unavailable";
    public static final String KEY_CHOOSE_SLOT = "spell_progression.choose";
    public static final int GUI_WIDTH = 252;
    public static final int GUI_HEIGHT = 140;
    private static final int WINDOW_OFF_X = 9;
    private static final int WINDOW_OFF_Y = 18;
    public static final int WINDOW_WIDTH = 234;
    public static final int WINDOW_HEIGHT = 113;
    public static final int BACKGROUND_TEXTURE_WIDTH = 16;
    public static final int BACKGROUND_TEXTURE_HEIGHT = 16;
    public static final int BACKGROUND_TILE_COUNT_X = 14;
    public static final int BACKGROUND_TILE_COUNT_Y = 7;
    public static final int TAB_ICON_WIDTH = 16;
    public static final int TAB_ICON_HEIGHT = 16;
    public static final int MAX_TABS = 8;
    public static final int TAB_FRAME_WIDTH = 32;
    public static final int TAB_FRAME_WIDTH_S = 28;
    public static final int TAB_FRAME_HEIGHT = 32;
    public static final int TAB_FRAME_HEIGHT_S = 28;
    public static final Component VERY_SAD_LABEL = new TranslatableComponent("advancements.sad_label");
    public static final Component NO_ADVANCEMENTS_LABEL = new TranslatableComponent("advancements.empty");
    private final Map<SpellNode, SpellTreeTab> tabs = Maps.newLinkedHashMap();
    @Nullable
    private SpellTreeTab selectedTab;
    private boolean isScrolling;
    private static int tabPage;
    private static int maxPages;
    public SelectedSpellWidget selectedSpellWidget;
    public SpellInteractButton learnButton;
    public SpellInteractButton equipButton;
    public SpellInteractButton unavailableButton;
    public SpellInteractButton chooseButton;
    public SpellSlotWidget[] spellSlotButtons;
    public SpellProgressionHolder spellProgressionHolder;

    public SpellProgressionScreen(SpellProgressionMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.f_96541_ = Minecraft.m_91087_();
        this.f_97726_ = 252;
        this.f_97727_ = 140;
        tabPage = 0;
        this.spellProgressionHolder = (SpellProgressionHolder)SpellProgressionHolder.getSpellProgressionHolder(menu.player).orElse(null);
    }

    public void spellTreesUpdated() {
        this.m_7856_();
    }

    protected void m_7856_() {
        this.tabs.clear();
        SpellTreeTab previous = this.selectedTab;
        this.selectedTab = null;
        this.m_169413_();
        super.m_7856_();
        maxPages = 0;
        if (((SpellProgressionMenu)this.f_97732_).spellTrees != null) {
            int index = 0;
            for (SpellTree tree2 : ((SpellProgressionMenu)this.f_97732_).spellTrees) {
                this.tabs.put(tree2.getRoot(), new SpellTreeTab(this.f_96541_, this, index % 8, index / 8, tree2));
                ++index;
            }
        }
        if (!this.tabs.isEmpty() && previous != null) {
            Optional<SpellTreeTab> optionalSpellTreeTab = this.tabs.values().stream().filter(tree -> previous.spellTree.getId().equals(tree.spellTree.getId())).findFirst();
            optionalSpellTreeTab.ifPresent(tab -> {
                this.selectedTab = tab;
                this.selectedTab.scroll(-this.selectedTab.getScrollX(), -this.selectedTab.getScrollY());
                this.selectedTab.scroll(previous.getScrollX(), previous.getScrollY());
                if (previous.root != null && this.selectedTab.root != null) {
                    this.selectedTab.scroll(previous.root.getX() - this.selectedTab.root.getX(), previous.root.getY() - this.selectedTab.root.getY());
                }
            });
        }
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.values().iterator().next();
        }
        if (this.tabs.size() > 8) {
            this.m_142416_((GuiEventListener)new Button(this.getGuiLeft(), this.getGuiTop() - 50, 20, 20, (Component)new TextComponent("<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }));
            this.m_142416_((GuiEventListener)new Button(this.getGuiLeft() + 252 - 20, this.getGuiTop() - 50, 20, 20, (Component)new TextComponent(">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }));
            maxPages = this.tabs.size() / 8;
        }
        int totalW = 280;
        int leftW = 150;
        int rightW = totalW - 180;
        this.selectedSpellWidget = new SelectedSpellWidget(this.getGuiLeft(), this.getGuiTop() + 140, leftW);
        this.learnButton = new SpellInteractButton(this.getGuiLeft() + 252 - rightW, this.getGuiTop() + 140, rightW, 26, (Component)new TranslatableComponent(KEY_LEARN), this::buttonClicked, 1, this::learnButtonTooltip){

            public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float deltaTick) {
                this.f_93623_ = SpellProgressionScreen.this.selectedSpellWidget.spell != null && SpellProgressionScreen.this.selectedSpellWidget.spell.canLearn(SpellProgressionScreen.this.spellProgressionHolder, ((SpellProgressionMenu)((SpellProgressionScreen)SpellProgressionScreen.this).f_97732_).access);
                super.m_6305_(poseStack, mouseX, mouseY, deltaTick);
            }

            @Override
            public void renderTitle(PoseStack poseStack, int mouseX, int mouseY, float deltaTick, Font font) {
                super.renderTitle(poseStack, mouseX, mouseY, deltaTick, font);
                if (SpellProgressionScreen.this.selectedSpellWidget.spell != null) {
                    int cost = SpellProgressionScreen.this.selectedSpellWidget.spell.getLevelCost();
                    int color = this.f_93623_ ? 8453920 : 4226832;
                    String costStr = String.valueOf(cost);
                    int x = this.f_93620_ + this.f_93618_ - font.m_92895_(costStr) - 2;
                    Objects.requireNonNull(font);
                    int y = this.f_93621_ + this.f_93619_ - 9 - 4;
                    font.m_92883_(poseStack, costStr, (float)x, (float)y, color);
                }
            }
        };
        this.equipButton = new SpellInteractButton(this.getGuiLeft() + 252 - rightW, this.getGuiTop() + 140, rightW, 26, (Component)new TranslatableComponent(KEY_EQUIP), this::buttonClicked, 0);
        this.unavailableButton = new SpellInteractButton(this.getGuiLeft() + 252 - rightW, this.getGuiTop() + 140, rightW, 26, (Component)new TranslatableComponent(KEY_UNAVAILABLE), this::buttonClicked, 2);
        this.chooseButton = new SpellInteractButton(this.getGuiLeft() + 252 - rightW, this.getGuiTop() + 140, rightW, 26, (Component)new TranslatableComponent(KEY_CHOOSE_SLOT), this::buttonClicked, 2);
        this.unavailableButton.f_93623_ = false;
        this.chooseButton.f_93623_ = false;
        this.m_7787_((GuiEventListener)this.learnButton);
        this.m_7787_((GuiEventListener)this.equipButton);
        this.m_7787_((GuiEventListener)this.unavailableButton);
        this.m_7787_((GuiEventListener)this.chooseButton);
        this.spellSlotButtons = new SpellSlotWidget[5];
        for (int i = 0; i < this.spellSlotButtons.length; ++i) {
            int x = this.getGuiLeft() - 26;
            int y = this.getGuiTop() + i * 27;
            int slot = i;
            this.spellSlotButtons[i] = new SpellSlotWidget(x, y, i, this::slotChosen, (b, pS, mX, mY) -> SpellSlotWidget.spellSlotToolTip((Screen)this, pS, mX, mY, slot));
        }
        this.disableSlotButtons();
        this.spellClicked(null);
    }

    private void learnButtonTooltip(Button button, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.selectedSpellWidget.spell != null && button.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_169388_(poseStack, this.selectedSpellWidget.spell.getTooltip(this.spellProgressionHolder, ((SpellProgressionMenu)this.f_97732_).access), Optional.empty(), mouseX, mouseY);
        }
    }

    private void buttonClicked(Button button) {
        if (button == this.equipButton) {
            this.enableSlotButtons();
            this.equipButton.f_93624_ = false;
            this.chooseButton.f_93624_ = true;
        } else if (button == this.learnButton && this.selectedTab != null) {
            SpellsAndShields.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new RequestLearnSpellMessage(this.selectedSpellWidget.spell.getId(), this.selectedSpellWidget.spell.getSpell(), this.selectedTab.spellTree.getId()));
        }
    }

    private void slotChosen(int slot) {
        if (this.selectedTab != null) {
            SpellsAndShields.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new RequestEquipSpellMessage(this.selectedSpellWidget.spell.getSpell(), (byte)slot, this.selectedTab.spellTree.getId()));
            this.spellClicked(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.learnButton.m_5953_(mouseX, mouseY) || this.equipButton.m_5953_(mouseX, mouseY) || this.unavailableButton.m_5953_(mouseX, mouseY)) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        for (SpellSlotWidget b : this.spellSlotButtons) {
            if (!b.m_5953_(mouseX, mouseY)) continue;
            return b.m_6375_(mouseX, mouseY, mouseButton);
        }
        this.spellClicked(null);
        if (mouseButton == 0) {
            block1: for (SpellTreeTab tab : this.tabs.values()) {
                if (tab.getPage() != tabPage) continue;
                if (tab.isMouseOver(this.getGuiLeft(), this.getGuiTop(), mouseX, mouseY)) {
                    this.selectedTab = tab;
                    break;
                }
                if (tab != this.selectedTab || !(mouseX >= (double)(this.getGuiLeft() + 9)) || !(mouseX < (double)(this.getGuiLeft() + 9 + 234)) || !(mouseY >= (double)(this.getGuiTop() + 18)) || !(mouseY < (double)(this.getGuiTop() + 18 + 113))) continue;
                int x = Mth.m_14107_((double)((double)this.getGuiLeft() + tab.getScrollX()));
                int y = Mth.m_14107_((double)((double)this.getGuiTop() + tab.getScrollY()));
                int mX = Mth.m_14107_((double)(mouseX - 9.0));
                int mY = Mth.m_14107_((double)(mouseY - 18.0));
                for (SpellNodeWidget w : tab.widgets.values()) {
                    if (!w.isMouseOver(x, y, mX, mY)) continue;
                    this.spellClicked(w);
                    continue block1;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void spellClicked(SpellNodeWidget w) {
        this.disableSlotButtons();
        this.chooseButton.f_93624_ = false;
        if (w == null) {
            this.selectedSpellWidget.active = false;
            this.learnButton.f_93624_ = false;
            this.equipButton.f_93624_ = false;
            this.unavailableButton.f_93624_ = false;
        } else {
            this.selectedSpellWidget.setClickedWidget(w);
            this.selectedSpellWidget.active = true;
            this.learnButton.f_93624_ = ProgressionHelper.isFullyLinked(w.spell, ((SpellProgressionMenu)this.f_97732_).spellProgression) && (w.spellStatus == SpellStatus.LOCKED || w.spellStatus == SpellStatus.FORGOTTEN);
            this.equipButton.f_93624_ = w.spellStatus == SpellStatus.LEARNED;
            this.unavailableButton.f_93624_ = !this.learnButton.f_93624_ && !this.equipButton.f_93624_;
        }
    }

    protected void enableSlotButtons() {
        for (SpellSlotWidget w : this.spellSlotButtons) {
            w.f_93623_ = true;
        }
    }

    protected void disableSlotButtons() {
        for (SpellSlotWidget w : this.spellSlotButtons) {
            w.f_93623_ = false;
        }
    }

    protected void m_7286_(PoseStack poseStack, float deltaTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        if (maxPages != 0) {
            TextComponent page = new TextComponent(String.format("%d / %d", tabPage + 1, maxPages + 1));
            int width = this.f_96547_.m_92852_((FormattedText)page);
            this.f_96547_.m_92744_(poseStack, page.m_7532_(), (float)this.getGuiLeft() + 126.0f - (float)width / 2.0f, (float)(this.getGuiTop() - 44), -1);
        }
        this.renderBottom(poseStack, mouseX, mouseY, deltaTick);
        this.renderSpellSlots(poseStack, mouseX, mouseY, deltaTick);
        this.renderInside(poseStack, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop());
        this.renderWindow(poseStack, this.getGuiLeft(), this.getGuiTop());
        this.renderTooltips(poseStack, mouseX, mouseY, this.getGuiLeft(), this.getGuiTop());
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (mouseButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(dragX, dragY);
        }
        return true;
    }

    private void renderInside(PoseStack poseStack, int mouseX, int mouseY, int offX, int offY) {
        SpellTreeTab tab = this.selectedTab;
        if (tab == null) {
            SpellProgressionScreen.m_93172_((PoseStack)poseStack, (int)(offX + 9), (int)(offY + 18), (int)(offX + 9 + 234), (int)(offY + 18 + 113), (int)-16777216);
            int i = offX + 9 + 117;
            SpellProgressionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_ADVANCEMENTS_LABEL, (int)i, (int)(offY + 18 + 56 - 4), (int)-1);
            SpellProgressionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)VERY_SAD_LABEL, (int)i, (int)(offY + 18 + 113 - 9), (int)-1);
        } else {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)(offX + 9), (double)(offY + 18), 0.0);
            RenderSystem.m_157182_();
            tab.drawContents(poseStack);
            posestack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
        }
    }

    public void renderWindow(PoseStack poseStack, int offX, int offY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WINDOW_LOCATION);
        this.m_93228_(poseStack, offX, offY, 0, 0, 252, 140);
        if (this.tabs.size() > 1) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TABS_LOCATION);
            for (SpellTreeTab tab : this.tabs.values()) {
                if (tab.getPage() != tabPage) continue;
                tab.drawTab(poseStack, offX, offY, tab == this.selectedTab);
            }
            RenderSystem.m_69453_();
            for (SpellTreeTab tab : this.tabs.values()) {
                if (tab.getPage() != tabPage) continue;
                tab.drawIcon(poseStack, offX, offY);
            }
            RenderSystem.m_69461_();
        }
    }

    private void renderTooltips(PoseStack poseStack, int mouseX, int mouseY, int offX, int offY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)(offX + 9), (double)(offY + 18), 400.0);
            RenderSystem.m_157182_();
            RenderSystem.m_69482_();
            this.selectedTab.drawTooltips(poseStack, mouseX - offX - 9, mouseY - offY - 18, offX, offY);
            RenderSystem.m_69465_();
            posestack.m_85849_();
            RenderSystem.m_157182_();
        }
        this.selectedSpellWidget.drawTooltip(poseStack, mouseX, mouseY, (Screen)this);
        for (SpellSlotWidget b : this.spellSlotButtons) {
            b.m_7428_(poseStack, mouseX, mouseY);
        }
        if (this.tabs.size() > 1) {
            for (SpellTreeTab tab : this.tabs.values()) {
                if (tab.getPage() != tabPage || !tab.isMouseOver(offX, offY, mouseX, mouseY)) continue;
                this.m_169388_(poseStack, tab.getTooltip(this.spellProgressionHolder, ((SpellProgressionMenu)this.f_97732_).access), Optional.empty(), mouseX, mouseY);
            }
        }
        this.learnButton.m_7428_(poseStack, mouseX, mouseY);
    }

    private void renderBottom(PoseStack poseStack, int mouseX, int mouseY, float deltaTick) {
        this.learnButton.m_6305_(poseStack, mouseX, mouseY, deltaTick);
        this.equipButton.m_6305_(poseStack, mouseX, mouseY, deltaTick);
        this.unavailableButton.m_6305_(poseStack, mouseX, mouseY, deltaTick);
        this.chooseButton.m_6305_(poseStack, mouseX, mouseY, deltaTick);
        this.selectedSpellWidget.drawHover(poseStack, deltaTick);
    }

    private void renderSpellSlots(PoseStack poseStack, int mouseX, int mouseY, float deltaTick) {
        for (SpellSlotWidget w : this.spellSlotButtons) {
            w.m_6305_(poseStack, mouseX, mouseY, deltaTick);
        }
    }
}

