/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.spell.ISpell;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public record RequestEquipSpellMessage(ISpell spell, byte slot, UUID treeId) {
    public static void encode(RequestEquipSpellMessage msg, FriendlyByteBuf buf) {
        if (msg.spell() != null) {
            buf.writeBoolean(true);
            buf.writeRegistryId((IForgeRegistryEntry)msg.spell());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)msg.slot());
        buf.m_130077_(msg.treeId());
    }

    public static RequestEquipSpellMessage decode(FriendlyByteBuf buf) {
        return new RequestEquipSpellMessage(buf.readBoolean() ? (ISpell)buf.readRegistryId() : null, buf.readByte(), buf.m_130259_());
    }

    public static void handle(RequestEquipSpellMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1429$temp = player.f_36096_;
            if (patt1429$temp instanceof SpellProgressionMenu) {
                SpellProgressionMenu menu = (SpellProgressionMenu)patt1429$temp;
                menu.equipSpellRequest(msg.spell(), msg.slot(), msg.treeId());
            }
        });
        context.get().setPacketHandled(true);
    }
}

