/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.client.ClientMessageHandler;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellTreeSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public record SpellProgressionSyncMessage(BlockPos blockPos, List<SpellTree> spellTrees, HashMap<ISpell, SpellStatus> map) {
    public static void encode(SpellProgressionSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.blockPos());
        buf.writeInt(msg.spellTrees().size());
        for (SpellTree spellTree : msg.spellTrees()) {
            SpellTreeSerializer.encodeTree(spellTree, buf);
        }
        buf.writeInt(msg.map().size());
        for (Map.Entry entry : msg.map().entrySet()) {
            buf.writeRegistryId((IForgeRegistryEntry)((ISpell)entry.getKey()));
            buf.writeByte(((SpellStatus)((Object)entry.getValue())).ordinal());
        }
    }

    public static SpellProgressionSyncMessage decode(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<SpellTree> spellTrees = new ArrayList<SpellTree>(size);
        for (int i = 0; i < size; ++i) {
            spellTrees.add(SpellTreeSerializer.decodeTree(buf));
        }
        size = buf.readInt();
        HashMap<ISpell, SpellStatus> map = new HashMap<ISpell, SpellStatus>(size);
        for (int i = 0; i < size; ++i) {
            ISpell spell = (ISpell)buf.readRegistryId();
            SpellStatus spellStatus = SpellStatus.values()[buf.readByte()];
            map.put(spell, spellStatus);
        }
        return new SpellProgressionSyncMessage(blockPos, spellTrees, map);
    }

    public static void handle(SpellProgressionSyncMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientMessageHandler.handleSpellProgressionSync(msg));
        context.get().setPacketHandled(true);
    }
}

