/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.progression;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.network.SpellProgressionSyncMessage;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class SpellProgressionMenu
extends AbstractContainerMenu {
    public static Component TITLE = new TranslatableComponent("container.spells_and_shields.spell_progression");
    public final ContainerLevelAccess access;
    public final Player player;
    public List<SpellTree> spellTrees;
    public HashMap<ISpell, SpellStatus> spellProgression;

    public SpellProgressionMenu(int id, Inventory inventory, ContainerLevelAccess containerLevelAccess, List<SpellTree> spellTrees, HashMap<ISpell, SpellStatus> spellProgression) {
        super((MenuType)SpellsRegistries.SPELL_PROGRESSION_MENU.get(), id);
        this.access = containerLevelAccess;
        this.player = inventory.f_35978_;
        this.spellTrees = spellTrees;
        this.spellProgression = spellProgression;
    }

    public void buySpellRequest(int id, ISpell spell, UUID treeId) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpellProgressionHolder.getSpellProgressionHolder((Player)player2).ifPresent(spellProgressionHolder -> this.access.m_39292_((level, blockPos) -> {
                if (ProgressionHelper.tryBuySpell(spellProgressionHolder, this, id, spell, treeId)) {
                    spellProgressionHolder.setSpellStatus(spell, SpellStatus.LEARNED);
                    level.m_5594_(null, blockPos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
                }
                this.spellTrees = ProgressionHelper.getStrippedSpellTrees(spellProgressionHolder, this.access);
                this.spellProgression = spellProgressionHolder.getProgression();
                SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SpellProgressionSyncMessage((BlockPos)blockPos, this.spellTrees, this.spellProgression));
            }));
        }
    }

    public void equipSpellRequest(ISpell spell, int slot, UUID treeId) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpellProgressionHolder.getSpellProgressionHolder((Player)player2).ifPresent(spellProgressionHolder -> SpellHolder.getSpellHolder((Player)player2).ifPresent(spellHolder -> {
                if (spell == null) {
                    spellHolder.setSpell(slot, null);
                } else if (spellProgressionHolder.getSpellStatus(spell).isAvailable()) {
                    spellHolder.setSpell(slot, spell);
                }
                spellHolder.sendSync();
            }));
        }
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, blockPos) -> !SpellsUtil.isEnchantingTable(level.m_8055_(blockPos).m_60734_()) ? false : player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public static SpellProgressionMenu construct(int id, Inventory inventory, FriendlyByteBuf extraData) {
        SpellProgressionSyncMessage msg = SpellProgressionSyncMessage.decode(extraData);
        return new SpellProgressionMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)inventory.f_35978_.f_19853_, (BlockPos)msg.blockPos()), msg.spellTrees(), msg.map());
    }
}

