/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class AdvancementRequirement
extends Requirement {
    public static final String ERROR_SUFFIX = ".error";
    protected ResourceLocation advancementRL;

    public AdvancementRequirement(IRequirementType.RequirementType type) {
        super(type);
    }

    public AdvancementRequirement(IRequirementType.RequirementType type, ResourceLocation advancementRL) {
        super(type);
        this.advancementRL = advancementRL;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return player2.m_8960_().m_135996_(a).m_8193_();
            }
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return new TranslatableComponent(this.descriptionId, new Object[]{a.m_138320_().m_14977_()});
            }
            return new TranslatableComponent(this.descriptionId + ERROR_SUFFIX, new Object[]{this.advancementRL.toString()});
        }
        return (MutableComponent)TextComponent.f_131282_;
    }

    @Override
    public void writeToJson(JsonObject json) {
        json.addProperty("advancement", this.advancementRL.toString());
    }

    @Override
    public void readFromJson(JsonObject json) {
        this.advancementRL = new ResourceLocation(SpellsFileUtil.jsonString(json, "advancement"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.advancementRL);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.advancementRL = (ResourceLocation)buf.readRegistryId();
    }
}

