/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IRequirementType
extends IForgeRegistryEntry<RequirementType> {
    public Requirement create(IRequirementType var1);

    default public Requirement makeInstance() {
        return this.create(this);
    }

    public static JsonObject writeToJson(Requirement requirement) {
        JsonObject json = new JsonObject();
        json.addProperty("type", requirement.getType().getRegistryName().toString());
        requirement.writeToJson(json);
        return json;
    }

    @Nullable
    public static Requirement readFromJson(JsonObject json) {
        String id = SpellsFileUtil.jsonString(json, "type");
        IRequirementType type = (IRequirementType)SpellsRegistries.REQUIREMENTS_REGISTRY.get().getValue(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        Requirement requirement = type.makeInstance();
        requirement.readFromJson(json);
        return requirement;
    }

    public static void writeToBuf(FriendlyByteBuf buf, Requirement requirement) {
        buf.writeRegistryId((IForgeRegistryEntry)requirement.getType());
        requirement.writeToBuf(buf);
    }

    public static Requirement readFromBuf(FriendlyByteBuf buf) {
        IRequirementType type = (IRequirementType)buf.readRegistryId();
        Requirement requirement = type.makeInstance();
        requirement.readFromBuf(buf);
        return requirement;
    }

    public static class RequirementType
    extends ForgeRegistryEntry<RequirementType>
    implements IRequirementType {
        public final Function<RequirementType, Requirement> factory;

        public RequirementType(Function<RequirementType, Requirement> factory) {
            this.factory = factory;
        }

        @Override
        public Requirement create(IRequirementType type) {
            return this.factory.apply((RequirementType)type);
        }
    }
}

