/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementStatus;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class WrappedRequirement
extends Requirement {
    protected Requirement requirement;
    protected RequirementStatus status;
    protected MutableComponent component;

    public WrappedRequirement(IRequirementType.RequirementType type) {
        super(type);
    }

    public WrappedRequirement(IRequirementType.RequirementType type, Requirement requirement) {
        super(type);
        this.requirement = requirement;
        this.status = RequirementStatus.UNDECIDED;
        this.component = null;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.status.isDecided() ? this.status.passes : this.requirement.passes(spellProgressionHolder, access);
    }

    @Override
    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        this.requirement.onSpellLearned(spellProgressionHolder, access);
    }

    public void decide(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        this.status = RequirementStatus.decide(this.passes(spellProgressionHolder, access));
        this.component = new TextComponent("- ").m_7220_((Component)this.makeDescription(spellProgressionHolder, access).m_130940_(this.status.passes ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.component != null ? this.component : this.requirement.makeDescription(spellProgressionHolder, access);
    }

    @Override
    public void writeToJson(JsonObject json) {
        throw new IllegalStateException();
    }

    @Override
    public void readFromJson(JsonObject json) {
        throw new IllegalStateException();
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeByte(this.status.ordinal());
        buf.m_130083_((Component)this.component);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.status = RequirementStatus.values()[buf.readByte()];
        this.component = (MutableComponent)buf.m_130238_();
    }

    public static WrappedRequirement wrap(Requirement requirement, SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        WrappedRequirement w = new WrappedRequirement((IRequirementType.RequirementType)SpellsRegistries.WRAPPED_REQUIREMENT.get(), requirement);
        w.decide(spellProgressionHolder, access);
        return w;
    }
}

