/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.spell.IConfigurableSpell;
import de.cas_ual_ty.spells.spell.IEquipSpell;
import de.cas_ual_ty.spells.spell.base.PassiveSpell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AttributeSpell
extends PassiveSpell
implements IEquipSpell,
IConfigurableSpell {
    public final Supplier<Attribute> defaultAttribute;
    public final AttributeModifier defaultAttributeModifier;
    protected Attribute attribute;
    protected AttributeModifier attributeModifier;

    public AttributeSpell(Supplier<Attribute> attribute, Supplier<String> name, double amount, AttributeModifier.Operation operation) {
        this.defaultAttribute = attribute;
        this.defaultAttributeModifier = new AttributeModifier(UUID.nameUUIDFromBytes("".getBytes(StandardCharsets.UTF_8)), name, amount, operation);
    }

    public AttributeSpell(Supplier<Attribute> attribute, double amount, AttributeModifier.Operation operation) {
        this(attribute, () -> Util.m_137492_((String)"effect", (ResourceLocation)((Attribute)attribute.get()).getRegistryName()), amount, operation);
    }

    @Override
    public void onEquip(SpellHolder spellHolder, int slot) {
        if (spellHolder.getPlayer().f_19853_.f_46443_) {
            return;
        }
        Player player = spellHolder.getPlayer();
        AttributeInstance ai = player.m_21051_(this.attribute);
        if (ai != null) {
            UUID uuid = SpellsUtil.generateUUIDForSlotAttribute(this.attribute, slot);
            AttributeModifier modifier = new AttributeModifier(uuid, this.attributeModifier.m_22214_(), this.attributeModifier.m_22218_(), this.attributeModifier.m_22217_());
            if (ai.m_22109_(modifier)) {
                ai.m_22120_(uuid);
            }
            ai.m_22125_(modifier);
        }
    }

    @Override
    public void onUnequip(SpellHolder spellHolder, int slot) {
        if (spellHolder.getPlayer().f_19853_.f_46443_) {
            return;
        }
        Player player = spellHolder.getPlayer();
        AttributeInstance ai = player.m_21051_(this.attribute);
        if (ai != null) {
            UUID uuid = SpellsUtil.generateUUIDForSlotAttribute(this.attribute, slot);
            ai.m_22127_(uuid);
        }
    }

    @Override
    public void addSpellDesc(List<Component> list) {
        list.add((Component)new TranslatableComponent(this.getDescKey()));
        if (this.attribute != null && this.attributeModifier != null) {
            list.add(TextComponent.f_131282_);
            list.add((Component)AttributeSpell.whenAppliedComponent());
            AttributeSpell.addTooltip(list, this.attribute, this.attributeModifier);
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        return new JsonObject();
    }

    @Override
    public void readFromConfig(JsonObject json) {
        this.attribute = this.defaultAttribute.get();
        this.attributeModifier = this.defaultAttributeModifier;
    }

    @Override
    public void applyDefaultConfig() {
        this.attribute = this.defaultAttribute.get();
        this.attributeModifier = this.defaultAttributeModifier;
    }

    public static void addTooltip(List<Component> list, Attribute attribute, AttributeModifier attributeModifier) {
        double amount = attributeModifier.m_22218_();
        double renderedAmount = attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributeModifier.m_22218_() : attributeModifier.m_22218_() * 100.0;
        if (amount > 0.0) {
            list.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(renderedAmount), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
        } else if (amount < 0.0) {
            list.add((Component)new TranslatableComponent("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(renderedAmount *= -1.0), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }
}

