/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HomingSpellProjectile
extends SpellProjectile {
    protected UUID targetUUID;
    protected Entity cachedTarget;

    public HomingSpellProjectile(EntityType<? extends HomingSpellProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public HomingSpellProjectile(EntityType<? extends HomingSpellProjectile> entityType, Level level, IProjectileSpell spell) {
        super(entityType, level, spell);
    }

    public void setOwnerAndTarget(Entity owner, Entity target) {
        this.m_5602_(owner);
        this.setTarget(target);
    }

    public void home(float velocity) {
        Vec3 direction = this.cachedTarget.m_146892_().m_82546_(this.m_20182_()).m_82541_();
        this.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.0f);
    }

    @Override
    public void m_8119_() {
        if (this.getTarget() != null && !this.getTarget().m_146910_()) {
            Vec3 movement = this.m_20184_();
            this.home((float)movement.m_82553_());
        }
        super.m_8119_();
    }

    public void setTarget(Entity target) {
        this.targetUUID = target.m_142081_();
        this.cachedTarget = target;
    }

    public Entity getTarget() {
        Level level;
        if (this.cachedTarget != null && !this.cachedTarget.m_146910_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedTarget = serverLevel.m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetUUID != null) {
            pCompound.m_128362_("Target", this.targetUUID);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("Target")) {
            this.targetUUID = pCompound.m_128342_("Target");
        }
    }

    public static void home(Vec3 position, Vec3 direction, @Nullable Entity source, Entity target, IProjectileSpell spell, float velocity, BiConsumer<HomingSpellProjectile, ServerLevel> followUp) {
        Level level = source.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            HomingSpellProjectile projectile = new HomingSpellProjectile((EntityType<? extends HomingSpellProjectile>)((EntityType)SpellsRegistries.HOMING_SPELL_PROJECTILE.get()), (Level)level2, spell);
            projectile.setOwnerAndTarget(source, target);
            projectile.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, source.m_146909_(), source.m_146908_());
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.0f);
            level2.m_7967_((Entity)projectile);
            followUp.accept(projectile, level2);
        }
    }

    public static void home(Entity source, IProjectileSpell spell, float velocity, Entity target, BiConsumer<HomingSpellProjectile, ServerLevel> followUp) {
        HomingSpellProjectile.home(source.m_146892_(), source.m_20252_(1.0f).m_82541_(), source, target, spell, velocity, followUp);
    }

    public static void home(Entity source, IProjectileSpell spell, float velocity, Entity target) {
        HomingSpellProjectile.home(source, spell, velocity, target, (entity, level) -> {});
    }
}

