/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.Spell;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class MultiIngredientSpell
extends Spell {
    public static final String KEY_REQUIRED_HAND = "spell.ingredients.hand";
    public static final String KEY_REQUIRED_INVENTORY = "spell.ingredients.inventory";
    public static final String KEY_INGREDIENT = "spell.ingredients.ingredient";
    public static final String KEY_INGREDIENT_MULTIPLE = "spell.ingredients.ingredient.multiple";

    public MultiIngredientSpell(float manaCost) {
        super(manaCost);
    }

    public void perform(ManaHolder manaHolder, Optional<List<ItemStack>> handIngredients, Optional<List<ItemStack>> inventoryIngredients) {
        this.perform(manaHolder);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
    }

    @Override
    public boolean activate(ManaHolder manaHolder) {
        if (this.canActivate(manaHolder)) {
            Optional<List<ItemStack>> handIngredients = this.findHandIngredients(manaHolder);
            Optional<List<ItemStack>> inventoryIngredients = this.findInventoryIngredients(manaHolder);
            LivingEntity livingEntity = manaHolder.getPlayer();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_7500_()) {
                    this.perform(manaHolder, handIngredients, inventoryIngredients);
                    return true;
                }
                if (handIngredients.isPresent() && inventoryIngredients.isPresent()) {
                    this.perform(manaHolder, handIngredients, inventoryIngredients);
                    this.burnMana(manaHolder);
                    this.consumeItemStacks(manaHolder, handIngredients.get(), inventoryIngredients.get());
                    return true;
                }
            } else {
                this.perform(manaHolder, handIngredients, inventoryIngredients);
                if (!manaHolder.getPlayer().f_19853_.f_46443_) {
                    this.consumeItemStacks(manaHolder, List.of(), List.of());
                }
                return true;
            }
        }
        return false;
    }

    public Optional<List<ItemStack>> findHandIngredients(ManaHolder manaHolder) {
        LinkedList<ItemStack> foundList = new LinkedList<ItemStack>();
        LivingEntity livingEntity = manaHolder.getPlayer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            InteractionHand prevHand = null;
            List<ItemStack> requiredList = this.getRequiredHandIngredients();
            for (ItemStack required : requiredList) {
                if (required.m_41619_()) continue;
                int count = required.m_41613_();
                for (InteractionHand hand : InteractionHand.values()) {
                    ItemStack toTest;
                    if (hand == prevHand || !ItemStack.m_150942_((ItemStack)(toTest = player.m_21120_(hand)), (ItemStack)required)) continue;
                    prevHand = hand;
                    foundList.add(toTest);
                    count -= toTest.m_41613_();
                }
                if (count <= 0) continue;
                return Optional.empty();
            }
        }
        return Optional.of(foundList);
    }

    public Optional<List<ItemStack>> findInventoryIngredients(ManaHolder manaHolder) {
        LinkedList<ItemStack> foundList = new LinkedList<ItemStack>();
        LivingEntity livingEntity = manaHolder.getPlayer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack required : this.getRequiredInventoryIngredients()) {
                if (required.m_41619_()) continue;
                int count = required.m_41613_();
                for (ItemStack toTest : player.m_150109_().f_35974_) {
                    if (toTest == player.m_21205_() || !ItemStack.m_150942_((ItemStack)toTest, (ItemStack)required)) continue;
                    foundList.add(toTest);
                    count -= toTest.m_41613_();
                }
                if (count <= 0) continue;
                return Optional.empty();
            }
        }
        return Optional.of(foundList);
    }

    public abstract List<ItemStack> getRequiredHandIngredients();

    public abstract List<ItemStack> getRequiredInventoryIngredients();

    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack required, ItemStack toTest) {
        return required.m_41619_() || toTest.m_41720_() == required.m_41720_() && toTest.m_41613_() >= required.m_41613_();
    }

    public boolean checkInventoryIngredient(ManaHolder manaHolder, ItemStack required, ItemStack toTest) {
        return required.m_41619_() || toTest.m_41720_() == required.m_41720_() && toTest.m_41613_() >= required.m_41613_();
    }

    public abstract void consumeItemStacks(ManaHolder var1, List<ItemStack> var2, List<ItemStack> var3);

    @Override
    public void addSpellDesc(List<Component> list) {
        super.addSpellDesc(list);
        List<ItemStack> handIngredients = this.getRequiredHandIngredients();
        List<ItemStack> inventoryIngredients = this.getRequiredInventoryIngredients();
        if (!handIngredients.isEmpty()) {
            list.add(TextComponent.f_131282_);
            list.add((Component)new TranslatableComponent(KEY_REQUIRED_HAND).m_130940_(ChatFormatting.BLUE));
            handIngredients.stream().map(itemStack -> new TextComponent(" ").m_7220_(itemStack.m_41786_()).m_130940_(ChatFormatting.YELLOW)).forEach(list::add);
        }
        if (!inventoryIngredients.isEmpty()) {
            list.add(TextComponent.f_131282_);
            list.add((Component)new TranslatableComponent(KEY_REQUIRED_INVENTORY).m_130940_(ChatFormatting.BLUE));
            inventoryIngredients.stream().map(itemStack -> new TextComponent(" ").m_7220_(itemStack.m_41786_()).m_130940_(ChatFormatting.YELLOW)).forEach(list::add);
        }
    }
}

