/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.AttributeSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spell.base.PassiveSpell;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TemporaryMobEffectSpell
extends BaseIngredientsSpell {
    public final MobEffect mobEffect;
    public final int duration;
    public final int amplifier;
    public final boolean ambient;
    public final boolean visible;
    public final boolean showIcon;

    public TemporaryMobEffectSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost, handIngredient);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect, int duration) {
        this(manaCost, handIngredient, mobEffect, duration, 0, false, true, true);
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect) {
        this(manaCost, handIngredient, mobEffect, 400);
    }

    public TemporaryMobEffectSpell(ItemStack handIngredient, MobEffect mobEffect) {
        this(5.0f, handIngredient, mobEffect, 400);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        manaHolder.getPlayer().m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier, this.ambient, this.visible, this.showIcon));
        manaHolder.getPlayer().f_19853_.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_12436_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public MutableComponent getSpellName() {
        TranslatableComponent component = new TranslatableComponent(this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = new TranslatableComponent("potion.withAmplifier", new Object[]{component, new TranslatableComponent("potion.potency." + this.amplifier)});
        }
        return new TranslatableComponent(this.getNameKey(), new Object[]{component});
    }

    @Override
    public MutableComponent getSpellDesc() {
        TranslatableComponent component = new TranslatableComponent(this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = new TranslatableComponent("potion.withAmplifier", new Object[]{component, new TranslatableComponent("potion.potency." + this.amplifier)});
        }
        return new TranslatableComponent(this.getDescKey(), new Object[]{component.m_130940_(ChatFormatting.YELLOW)});
    }

    @Override
    public void addSpellDesc(List<Component> list) {
        super.addSpellDesc(list);
        Map map = this.mobEffect.m_19485_();
        if (!map.isEmpty()) {
            list.add(TextComponent.f_131282_);
            list.add((Component)PassiveSpell.whenAppliedComponent());
            for (Map.Entry entry : map.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                attributeModifier = new AttributeModifier(attributeModifier.m_22214_(), this.mobEffect.m_7048_(this.amplifier, attributeModifier), attributeModifier.m_22217_());
                AttributeSpell.addTooltip(list, attribute, attributeModifier);
            }
        }
    }
}

