/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spell.base.HomingSpellProjectile;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DrainFlameSpell
extends BaseIngredientsSpell
implements IProjectileSpell {
    public DrainFlameSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients) {
        super(manaCost, handIngredients, inventoryIngredients);
    }

    public DrainFlameSpell(float manaCost, ItemStack handIngredient) {
        super(manaCost, handIngredient);
    }

    public DrainFlameSpell(float manaCost) {
        super(manaCost);
    }

    public DrainFlameSpell() {
        super(0.0f);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        LivingEntity entity;
        Level level = entity.f_19853_;
        entity = manaHolder.getPlayer();
        HitResult hit = SpellsUtil.rayTrace(level, (Entity)entity, 50.0, e -> e instanceof LivingEntity, 0.5f, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
        if (hit.m_6662_() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.m_82425_();
            for (int i = 0; i < 2; ++i) {
                BlockState blockState = level.m_8055_(pos);
                BlockPos below = pos.m_7495_();
                Block block = blockState.m_60734_();
                if (block instanceof BaseFireBlock) {
                    BaseFireBlock baseFireBlock = (BaseFireBlock)block;
                    if (level.m_8055_(below).isFireSource((LevelReader)level, below, Direction.UP)) {
                        level.m_7471_(pos, false);
                        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        Vec3 position = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        Vec3 direction = entity.m_20182_().m_82546_(position).m_82541_();
                        HomingSpellProjectile.home(position, direction, (Entity)entity, (Entity)entity, this, 1.0f, (projectile, pLevel) -> {});
                        return;
                    }
                }
                pos = pos.m_7494_();
            }
        }
    }

    @Override
    public void projectileTick(SpellProjectile entity) {
        Vec3 pos = entity.m_20182_();
        Random random = new Random();
        if (entity.f_19797_ % 4 == 0) {
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
        double spread = 0.2;
        for (int i = 0; i < 2; ++i) {
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_ + random.nextGaussian() * 0.2, pos.f_82480_ + random.nextGaussian() * 0.2, pos.f_82481_ + random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_ + random.nextGaussian() * 0.2, pos.f_82480_ + random.nextGaussian() * 0.2, pos.f_82481_ + random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123745_;
    }

    @Override
    public void projectileHitEntity(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity entity2 = entityHitResult.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            target.m_7292_(new MobEffectInstance((MobEffect)SpellsRegistries.REPLENISHMENT_EFFECT.get(), 200));
            target.f_19853_.m_6269_(null, (Entity)target, SoundEvents.f_11936_, SoundSource.PLAYERS, 1.0f, 1.0f);
            IProjectileSpell.super.projectileHitEntity(entity, entityHitResult);
        }
    }
}

