/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.SpellDataHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.ITickedDataSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.spelldata.ISpellDataType;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FlamethrowerSpell
extends BaseIngredientsSpell
implements IProjectileSpell,
ITickedDataSpell {
    public final int defaultFireSeconds;
    public final int defaultRepetitions;
    public final int defaultRepetitionDelay;
    public final int defaultShotsPerRepetition;
    public final float defaultInaccuracy;
    protected int fireSeconds;
    protected int repetitions;
    protected int repetitionDelay;
    protected int shotsPerRepetition;
    protected float inaccuracy;
    protected int maxTime;

    public FlamethrowerSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int fireSeconds, int repetitions, int repetitionDelay, int shotsPerRepetition, float inaccuracy) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultFireSeconds = fireSeconds;
        this.defaultRepetitions = repetitions;
        this.defaultRepetitionDelay = repetitionDelay;
        this.defaultShotsPerRepetition = shotsPerRepetition;
        this.defaultInaccuracy = inaccuracy;
    }

    public FlamethrowerSpell(float manaCost, ItemStack ingredient, int fireSeconds, int repetitions, int repetitionDelay, int shotsPerRepetition, float inaccuracy) {
        super(manaCost, ingredient);
        this.defaultFireSeconds = fireSeconds;
        this.defaultRepetitions = repetitions;
        this.defaultRepetitionDelay = repetitionDelay;
        this.defaultShotsPerRepetition = shotsPerRepetition;
        this.defaultInaccuracy = inaccuracy;
    }

    public FlamethrowerSpell(float manaCost, int fireSeconds, int repetitions, int repetitionDelay, int shotsPerRepetition, float inaccuracy) {
        super(manaCost);
        this.defaultFireSeconds = fireSeconds;
        this.defaultRepetitions = repetitions;
        this.defaultRepetitionDelay = repetitionDelay;
        this.defaultShotsPerRepetition = shotsPerRepetition;
        this.defaultInaccuracy = inaccuracy;
    }

    public FlamethrowerSpell() {
        this(7.0f, new ItemStack((ItemLike)Items.f_42593_), 10, 5, 4, 3, 15.0f);
    }

    @Override
    public int getTimeout() {
        return 20;
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        SpellDataHolder.getSpellDataHolder(manaHolder.getPlayer()).ifPresent(spellDataHolder -> spellDataHolder.add(ITickedDataSpell.makeData((ISpellDataType)SpellsRegistries.FLAMETHROWER_DATA.get())));
    }

    @Override
    public void projectileHitEntity(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity entity2 = entityHitResult.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity hit = (LivingEntity)entity2;
            hit.m_20254_(this.fireSeconds);
        }
        IProjectileSpell.super.projectileHitEntity(entity, entityHitResult);
    }

    @Override
    public void projectileHitBlock(SpellProjectile entity, BlockHitResult blockHitResult) {
        BlockPos blockpos;
        if (!entity.f_19853_.f_46443_ && entity.f_19853_.m_46859_(blockpos = blockHitResult.m_82425_().m_142300_(blockHitResult.m_82434_()))) {
            entity.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)entity.f_19853_, (BlockPos)blockpos));
        }
        IProjectileSpell.super.projectileHitBlock(entity, blockHitResult);
    }

    @Override
    public int getMaxTime(SpellDataHolder spellDataHolder) {
        return this.maxTime;
    }

    @Override
    public void dataTick(SpellDataHolder spellDataHolder, int tickTime) {
        ManaHolder.getManaHolder(spellDataHolder.getEntity()).ifPresent(manaHolder -> {
            if (tickTime % this.repetitionDelay == 0) {
                for (int i = 0; i < this.shotsPerRepetition; ++i) {
                    this.shootStraight((ManaHolder)manaHolder, 2.0f, this.inaccuracy, (projectile, level) -> {});
                }
                spellDataHolder.getEntity().f_19853_.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
    }

    @Override
    public void projectileTick(SpellProjectile entity) {
        if (entity.f_19853_.f_46443_) {
            Vec3 pos = entity.m_20182_();
            Random random = new Random();
            if (entity.f_19797_ % 4 == 0) {
                entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            double spread = 0.1;
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_ + random.nextGaussian() * 0.1, pos.f_82480_ + random.nextGaussian() * 0.1, pos.f_82481_ + random.nextGaussian() * 0.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123744_;
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("fireSeconds", (Number)this.defaultFireSeconds);
        json.addProperty("repetitions", (Number)this.defaultRepetitions);
        json.addProperty("repetitionDelay", (Number)this.defaultRepetitionDelay);
        json.addProperty("shotsPerRepetition", (Number)this.defaultShotsPerRepetition);
        json.addProperty("inaccuracy", (Number)Float.valueOf(this.defaultInaccuracy));
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.fireSeconds = SpellsFileUtil.jsonInt(json, "fireSeconds");
        this.repetitions = SpellsFileUtil.jsonInt(json, "repetitions");
        this.repetitionDelay = SpellsFileUtil.jsonInt(json, "repetitionDelay");
        this.shotsPerRepetition = SpellsFileUtil.jsonInt(json, "shotsPerRepetition");
        this.inaccuracy = SpellsFileUtil.jsonFloat(json, "inaccuracy");
        this.calculateMaxTime();
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.fireSeconds = this.defaultFireSeconds;
        this.repetitions = this.defaultRepetitions;
        this.repetitionDelay = this.defaultRepetitionDelay;
        this.shotsPerRepetition = this.defaultShotsPerRepetition;
        this.inaccuracy = this.defaultInaccuracy;
        this.calculateMaxTime();
    }

    protected void calculateMaxTime() {
        if (this.repetitions > 0 && this.repetitionDelay > 0) {
            this.maxTime = this.repetitions * this.repetitionDelay;
        } else {
            this.repetitions = 1;
            this.repetitionDelay = 0;
            this.maxTime = 0;
        }
    }
}

