/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.SpellDataHolder;
import de.cas_ual_ty.spells.spell.ITickedDataSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spelldata.ISpellDataType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class GhastSpell
extends BaseIngredientsSpell
implements ITickedDataSpell {
    public GhastSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients) {
        super(manaCost, handIngredients, inventoryIngredients);
    }

    public GhastSpell(float manaCost, ItemStack handIngredient) {
        super(manaCost, handIngredient);
    }

    public GhastSpell(float manaCost) {
        super(manaCost);
    }

    public GhastSpell() {
        this(4.0f, new ItemStack((ItemLike)Items.f_42613_));
    }

    @Override
    public boolean canActivate(ManaHolder manaHolder) {
        LazyOptional<SpellDataHolder> spellDataHolder = SpellDataHolder.getSpellDataHolder(manaHolder.getPlayer());
        if (super.canActivate(manaHolder) && spellDataHolder.isPresent()) {
            AtomicBoolean activate = new AtomicBoolean(true);
            spellDataHolder.ifPresent(spellDataHolder1 -> activate.set(!spellDataHolder1.hasOfType((ISpellDataType)SpellsRegistries.GHAST_DATA.get())));
            return activate.get();
        }
        return false;
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        SpellDataHolder.getSpellDataHolder(manaHolder.getPlayer()).ifPresent(spellDataHolder -> spellDataHolder.add(ITickedDataSpell.makeData((ISpellDataType)SpellsRegistries.GHAST_DATA.get())));
    }

    @Override
    public int getMaxTime(SpellDataHolder spellDataHolder) {
        return 20;
    }

    @Override
    public void dataTick(SpellDataHolder spellDataHolder, int tickTime) {
        Level level = spellDataHolder.getEntity().f_19853_;
        LivingEntity entity = spellDataHolder.getEntity();
        if (tickTime == 10) {
            level.m_6269_(null, (Entity)entity, SoundEvents.f_11924_, SoundSource.PLAYERS, 10.0f, 1.0f);
        } else if (tickTime == 20) {
            Vec3 view = entity.m_20252_(1.0f).m_82490_(2.0);
            LargeFireball fireball = new LargeFireball(level, entity, view.f_82479_, view.f_82480_, view.f_82481_, 1);
            fireball.m_146884_(entity.m_146892_().m_82549_(view).m_82549_(entity.m_20184_()));
            level.m_6269_(null, (Entity)entity, SoundEvents.f_11923_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_7967_((Entity)fireball);
        }
    }
}

