/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GrowthSpell
extends BaseIngredientsSpell {
    public final int defaultRange;
    protected int range;

    public GrowthSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int range) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultRange = range;
    }

    public GrowthSpell(float manaCost, ItemStack handIngredient, int range) {
        super(manaCost, handIngredient);
        this.defaultRange = range;
    }

    public GrowthSpell(float manaCost, int range) {
        super(manaCost);
        this.defaultRange = range;
    }

    public GrowthSpell() {
        this(4.0f, new ItemStack((ItemLike)Items.f_42499_), 3);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        LivingEntity livingEntity = manaHolder.getPlayer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = player.f_19853_;
            if (livingEntity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)livingEntity;
                BlockPos pos0 = manaHolder.getPlayer().m_20097_();
                for (int x = -this.range; x <= this.range; ++x) {
                    for (int z = -this.range; z <= this.range; ++z) {
                        for (int y = 0; y <= 2; ++y) {
                            BlockPos pos = pos0.m_142082_(x, y, z);
                            Vec3 pos1 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                            BoneMealItem.applyBonemeal((ItemStack)ItemStack.f_41583_, (Level)player.f_19853_, (BlockPos)pos, (Player)player);
                            level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
                level.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_144074_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("range", (Number)this.defaultRange);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.range = SpellsFileUtil.jsonInt(json, "range");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.range = this.defaultRange;
    }
}

