/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IClientSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class JumpSpell
extends BaseIngredientsSpell
implements IClientSpell {
    public final double defaultSpeed;
    protected double speed;

    public JumpSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, double speed) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultSpeed = speed;
    }

    public JumpSpell(float manaCost, ItemStack ingredient, double speed) {
        super(manaCost, ingredient);
        this.defaultSpeed = speed;
    }

    public JumpSpell(float manaCost, double speed) {
        super(manaCost);
        this.defaultSpeed = speed;
    }

    public JumpSpell() {
        this(5.0f, 1.5);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        LivingEntity entity = manaHolder.getPlayer();
        Vec3 direction = entity.m_20184_().m_82520_(0.0, this.speed, 0.0);
        entity.m_20256_(direction);
        entity.f_19789_ = 0.0f;
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 4;
            double spread = 0.1;
            Vec3 position = entity.m_20182_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, position.f_82479_, position.f_82480_, position.f_82481_, 4, entity.m_21187_().nextGaussian() * 0.1, entity.m_21187_().nextGaussian() * 0.1, entity.m_21187_().nextGaussian() * 0.1, 0.0);
        }
    }

    @Override
    public void performOnClient(ManaHolder manaHolder) {
        this.perform(manaHolder);
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("speed", (Number)this.defaultSpeed);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.speed = SpellsFileUtil.jsonDouble(json, "speed");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.speed = this.defaultSpeed;
    }
}

