/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IClientSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LeapSpell
extends BaseIngredientsSpell
implements IClientSpell {
    public final double defaultSpeed;
    protected double speed;

    public LeapSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, double speed) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultSpeed = speed;
    }

    public LeapSpell(float manaCost, ItemStack handIngredient, double speed) {
        super(manaCost, handIngredient);
        this.defaultSpeed = speed;
    }

    public LeapSpell(float manaCost, double speed) {
        super(manaCost);
        this.defaultSpeed = speed;
    }

    public LeapSpell() {
        this(6.0f, 2.5);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        LivingEntity entity = manaHolder.getPlayer();
        Vec3 direction = entity.m_20252_(1.0f).m_82541_();
        double y = direction.f_82480_;
        direction = direction.m_82520_(0.0, -direction.f_82480_, 0.0).m_82490_(this.speed);
        entity.m_20334_(direction.f_82479_, Math.max(0.5, y + 0.5), direction.f_82481_);
        entity.f_19789_ = 0.0f;
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 4;
            double spread = 0.1;
            Vec3 position = entity.m_20182_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, position.f_82479_, position.f_82480_, position.f_82481_, 4, entity.m_21187_().nextGaussian() * 0.1, entity.m_21187_().nextGaussian() * 0.1, entity.m_21187_().nextGaussian() * 0.1, 0.0);
            serverLevel.m_6269_(null, (Entity)manaHolder.getPlayer(), this.getJumpSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_11893_;
    }

    @Override
    public void performOnClient(ManaHolder manaHolder) {
        this.perform(manaHolder);
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("speed", (Number)this.defaultSpeed);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.speed = SpellsFileUtil.jsonDouble(json, "speed");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.speed = this.defaultSpeed;
    }
}

