/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RandomTeleportSpell
extends BaseIngredientsSpell {
    public final int defaultAttempts;
    public final int defaultTeleportRange;
    protected int attempts;
    protected int teleportRange;

    public RandomTeleportSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int attempts, int teleportRange) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultAttempts = attempts;
        this.defaultTeleportRange = teleportRange;
    }

    public RandomTeleportSpell(float manaCost, ItemStack handIngredient, int attempts, int teleportRange) {
        super(manaCost, handIngredient);
        this.defaultAttempts = attempts;
        this.defaultTeleportRange = teleportRange;
    }

    public RandomTeleportSpell(float manaCost, int attempts, int teleportRange) {
        super(manaCost);
        this.defaultAttempts = attempts;
        this.defaultTeleportRange = teleportRange;
    }

    public RandomTeleportSpell() {
        this(5.0f, new ItemStack((ItemLike)Items.f_42730_), 5, 32);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        RandomTeleportSpell.randomTeleport(manaHolder.getPlayer(), manaHolder.getPlayer().f_19853_, this.attempts, this.teleportRange);
    }

    public static boolean randomTeleport(LivingEntity entity, Level level, int attempts, int range) {
        Random random = entity.m_21187_();
        Vec3 pos = entity.m_20182_();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        boolean success = false;
        for (int i = 0; !success && i < attempts; ++i) {
            x = entity.m_20185_() + (random.nextDouble() - 0.5) * (double)range * 2.0;
            y = entity.m_20186_() + (double)(random.nextInt(range * 2) - range);
            z = entity.m_20189_() + (random.nextDouble() - 0.5) * (double)range * 2.0;
            success = entity.m_20984_(x, y, z, true);
        }
        if (success) {
            level.m_6263_(null, x, y, z, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_6269_(null, (Entity)entity, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        level.m_6269_(null, (Entity)entity, SoundEvents.f_11850_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return false;
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("attempts", (Number)this.defaultAttempts);
        json.addProperty("teleportRange", (Number)this.defaultTeleportRange);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.attempts = SpellsFileUtil.jsonInt(json, "attempts");
        this.teleportRange = SpellsFileUtil.jsonInt(json, "teleportRange");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.attempts = this.defaultAttempts;
        this.teleportRange = this.defaultTeleportRange;
    }
}

