/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.spell.IEventSpell;
import de.cas_ual_ty.spells.spell.base.PassiveSpell;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;

public class WalkerSpell
extends PassiveSpell
implements IEventSpell {
    protected Supplier<Block> oldBlock;
    protected Supplier<Material> oldMaterial;
    protected Supplier<BlockState> newBlock;

    public WalkerSpell(Supplier<Block> oldBlock, Supplier<Material> oldMaterial, Supplier<BlockState> newBlock) {
        this.oldBlock = oldBlock;
        this.oldMaterial = oldMaterial;
        this.newBlock = newBlock;
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        SpellHolder.getSpellHolder(event.player).ifPresent(spellHolder -> {
            int amount = spellHolder.getAmountSpellEquipped(this);
            if (amount > 0) {
                WalkerSpell.onEntityMoved((LivingEntity)spellHolder.getPlayer(), amount, this.oldBlock.get(), this.oldMaterial.get(), this.newBlock.get());
            }
        });
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
    }

    public static void onEntityMoved(LivingEntity livingEntity, int extraRadius, Block oldBlock, Material oldMaterial, BlockState newBlock) {
        Level level = livingEntity.f_19853_;
        if (!level.f_46443_ && livingEntity.m_20096_()) {
            BlockPos pos = livingEntity.m_142538_();
            double r = Math.min(16, 2 + extraRadius);
            for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)pos.m_142022_(-r, -1.0, -r), (BlockPos)pos.m_142022_(r, -1.0, r))) {
                boolean isFull;
                BlockState above;
                if (!currentPos.m_203195_((Position)livingEntity.m_20182_(), r) || !(above = level.m_8055_(currentPos.m_7494_())).m_60795_()) continue;
                BlockState currentBlock = level.m_8055_(currentPos);
                boolean bl = isFull = currentBlock.m_60734_() == oldBlock && (Integer)currentBlock.m_61143_((Property)LiquidBlock.f_54688_) == 0;
                if (currentBlock.m_60767_() != oldMaterial || !isFull || !newBlock.m_60710_((LevelReader)level, currentPos) || !level.m_45752_(newBlock, currentPos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)livingEntity, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)currentPos), (Direction)Direction.UP)) continue;
                level.m_46597_(currentPos, newBlock);
                level.m_186460_(currentPos, newBlock.m_60734_(), Mth.m_14072_((Random)livingEntity.m_21187_(), (int)60, (int)120));
            }
        }
    }
}

