/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelldata;

import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.spelldata.SpellData;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface ISpellDataType
extends IForgeRegistryEntry<SpellDataType> {
    public SpellData create(ISpellDataType var1);

    default public SpellData makeInstance() {
        return this.create(this);
    }

    public static CompoundTag serialize(SpellData data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", data.getType().getRegistryName().toString());
        data.write(tag);
        return tag;
    }

    @Nullable
    public static SpellData deserialize(CompoundTag tag) {
        String id = tag.m_128461_("type");
        ISpellDataType type = (ISpellDataType)SpellsRegistries.SPELL_DATA_REGISTRY.get().getValue(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        SpellData data = type.makeInstance();
        data.read(tag);
        return data;
    }

    public static class SpellDataType
    extends ForgeRegistryEntry<SpellDataType>
    implements ISpellDataType {
        public final Function<SpellDataType, SpellData> factory;

        public SpellDataType(Function<SpellDataType, SpellData> factory) {
            this.factory = factory;
        }

        @Override
        public SpellData create(ISpellDataType type) {
            return this.factory.apply((SpellDataType)type);
        }
    }
}

