/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import com.google.gson.JsonElement;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.event.AvailableSpellTreesEvent;
import de.cas_ual_ty.spells.requirement.AdvancementRequirement;
import de.cas_ual_ty.spells.requirement.BookshelvesRequirement;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.ItemRequirement;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellTreeSerializer;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;

public class SpellTrees {
    public static final List<SpellTree> LOADED_SPELL_TREES = new ArrayList<SpellTree>();
    public static final String KEY_NETHER = "spell_tree.nether";
    public static final String KEY_OCEAN = "spell_tree.ocean";
    public static final String KEY_MINING = "spell_tree.mining";
    public static final String KEY_MOVEMENT = "spell_tree.movement";
    public static final String KEY_END = "spell_tree.end";

    public static List<SpellTree> getBaseTrees() {
        ArrayList<SpellTree> list = new ArrayList<SpellTree>(5);
        list.add(SpellTrees.fireTree());
        list.add(SpellTrees.waterTree());
        list.add(SpellTrees.earthTree());
        list.add(SpellTrees.airTree());
        list.add(SpellTrees.enderTree());
        return list;
    }

    public static SpellTree fireTree() {
        return SpellTree.builder("spells_and_shields.nether", (Component)new TranslatableComponent(KEY_NETHER), Spells.FIRE_BALL, 15, new Requirement[]{SpellTrees.bookshelves(28)}).icon((ISpell)Spells.TEMPORARY_FIRE_RESISTANCE.get()).add((Supplier<ISpell>)Spells.LAVA_WALKER, 20, SpellTrees.bookshelves(19)).add((Supplier<ISpell>)Spells.TEMPORARY_FIRE_RESISTANCE, 30, SpellTrees.bookshelves(30)).leaf().add((Supplier<ISpell>)Spells.DRAIN_FLAME, 20, SpellTrees.bookshelves(20)).leaf().leaf().add((Supplier<ISpell>)Spells.GHAST, 10, SpellTrees.bookshelves(20), SpellTrees.item(Items.f_42586_, 1, true)).add((Supplier<ISpell>)Spells.FLAMETHROWER, 20, SpellTrees.bookshelves(24)).finish();
    }

    public static SpellTree waterTree() {
        return SpellTree.builder("spells_and_shields.ocean", (Component)new TranslatableComponent(KEY_OCEAN), Spells.TEMPORARY_WATER_BREATHING, 10, new Requirement[0]).icon((ISpell)Spells.TEMPORARY_DOLPHINS_GRACE.get()).add((Supplier<ISpell>)Spells.TEMPORARY_REGENERATION, 20, SpellTrees.bookshelves(20)).add((Supplier<ISpell>)Spells.GROWTH, 20, SpellTrees.bookshelves(20)).leaf().add((Supplier<ISpell>)Spells.AQUA_AFFINITY, 20, SpellTrees.bookshelves(20)).leaf().leaf().add((Supplier<ISpell>)Spells.WATER_LEAP, 5, SpellTrees.bookshelves(10)).add((Supplier<ISpell>)Spells.TEMPORARY_DOLPHINS_GRACE, 30, SpellTrees.bookshelves(30)).leaf().add((Supplier<ISpell>)Spells.FROST_WALKER, 10, SpellTrees.bookshelves(14)).leaf().leaf().add((Supplier<ISpell>)Spells.WATER_WHIP, 10, SpellTrees.bookshelves(10)).add((Supplier<ISpell>)Spells.POTION_SHOT, 10, SpellTrees.bookshelves(10)).leaf().leaf().add((Supplier<ISpell>)Spells.LIGHTNING_STRIKE, 25, SpellTrees.bookshelves(24), SpellTrees.advancement("adventure/lightning_rod_with_villager_no_fire")).leaf().finish();
    }

    public static SpellTree earthTree() {
        return SpellTree.builder("spells_and_shields.mining", (Component)new TranslatableComponent(KEY_MINING), Spells.BLAST_SMELT, 5, new Requirement[]{SpellTrees.bookshelves(8)}).icon((ISpell)Spells.TEMPORARY_HASTE.get()).add((Supplier<ISpell>)Spells.SILENCE_TARGET, 25, SpellTrees.bookshelves(26)).add((Supplier<ISpell>)Spells.TEMPORARY_MAGIC_IMMUNE, 25, SpellTrees.bookshelves(26)).leaf().leaf().add((Supplier<ISpell>)Spells.INSTANT_MINE, 15, SpellTrees.bookshelves(18)).add((Supplier<ISpell>)Spells.TEMPORARY_HASTE, 25, SpellTrees.bookshelves(24)).leaf().leaf().add((Supplier<ISpell>)Spells.SPIT_METAL, 10, SpellTrees.bookshelves(12)).finish();
    }

    public static SpellTree airTree() {
        return SpellTree.builder("spells_and_shields.movement", (Component)new TranslatableComponent(KEY_MOVEMENT), Spells.TEMPORARY_JUMP_BOOST, 15, new Requirement[]{SpellTrees.bookshelves(12)}).icon((ISpell)Spells.TEMPORARY_JUMP_BOOST.get()).add((Supplier<ISpell>)Spells.LEAP, 10, SpellTrees.bookshelves(14)).add((Supplier<ISpell>)Spells.TEMPORARY_SPEED, 20, SpellTrees.bookshelves(20)).leaf().add((Supplier<ISpell>)Spells.JUMP, 14, SpellTrees.bookshelves(14)).leaf().add((Supplier<ISpell>)Spells.MANA_SOLES, 15, SpellTrees.bookshelves(12)).add((Supplier<ISpell>)Spells.TEMPORARY_SLOW_FALLING, 15, SpellTrees.bookshelves(16)).leaf().leaf().add((Supplier<ISpell>)Spells.BLOW_ARROW, 10, SpellTrees.bookshelves(16)).add((Supplier<ISpell>)Spells.PRESSURIZE, 20, SpellTrees.bookshelves(18)).leaf().leaf().finish();
    }

    public static SpellTree enderTree() {
        return SpellTree.builder("spells_and_shields.end", (Component)new TranslatableComponent(KEY_END), Spells.RANDOM_TELEPORT, 20, new Requirement[]{SpellTrees.bookshelves(28)}).icon((ISpell)Spells.TELEPORT.get()).requirement(SpellTrees.advancement("end/root")).add((ISpell)Spells.FORCED_TELEPORT.get(), 30, SpellTrees.bookshelves(28)).leaf().add((ISpell)Spells.TELEPORT.get(), 30, SpellTrees.bookshelves(28), SpellTrees.advancement("end/respawn_dragon")).add((ISpell)Spells.ENDER_ARMY.get(), 50, SpellTrees.bookshelves(30), SpellTrees.item(Items.f_42104_, 1, false)).finish();
    }

    public static Requirement bookshelves(int bookshelves) {
        return new BookshelvesRequirement((IRequirementType.RequirementType)SpellsRegistries.BOOKSHELVES_REQUIREMENT.get(), bookshelves);
    }

    public static Requirement advancement(String advancementRL) {
        return new AdvancementRequirement((IRequirementType.RequirementType)SpellsRegistries.ADVANCEMENT_REQUIREMENT.get(), new ResourceLocation(advancementRL));
    }

    public static Requirement item(Item item, int count, boolean consume) {
        return new ItemRequirement((IRequirementType.RequirementType)SpellsRegistries.ITEM_REQUIREMENT.get(), new ItemStack((ItemLike)item, count), consume);
    }

    public static void readOrWriteSpellTreeConfigs() {
        List<SpellTree> baseTrees = SpellTrees.getBaseTrees();
        if (((Boolean)SpellsConfig.ADD_DEFAULT_SPELL_TREES.get()).booleanValue()) {
            LOADED_SPELL_TREES.addAll(baseTrees);
        }
        boolean makeConfigs = !SpellsFileUtil.doesSubConfigDirExist("spell_trees");
        Path p = SpellsFileUtil.getOrCreateSubConfigDir("spell_trees");
        File folder = p.toFile();
        if (!folder.isDirectory() || folder.listFiles() == null) {
            SpellsAndShields.LOGGER.error("Can not read or write spell tree files in {} (is it a folder?).", (Object)p);
            return;
        }
        if (((Boolean)SpellsConfig.CREATE_DEFAULT_SPELL_TREES.get()).booleanValue()) {
            SpellsConfig.CREATE_DEFAULT_SPELL_TREES.set((Object)false);
            SpellsConfig.CREATE_DEFAULT_SPELL_TREES.save();
            int i = 0;
            for (SpellTree t : baseTrees) {
                Object filename = t.filename != null ? t.filename : "tree_" + i;
                File f = p.resolve((String)filename + ".json").toFile();
                ++i;
                try {
                    SpellsFileUtil.writeJsonToFile(f, (JsonElement)SpellTreeSerializer.treeToJson(t));
                    SpellsAndShields.LOGGER.info("Wrote default spell tree {} to file {}.", (Object)t.getId(), (Object)f.toPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SpellsAndShields.LOGGER.error("Failed writing default spell tree {} to file {}.", (Object)t.getId().toString(), (Object)f.toPath(), (Object)e);
                }
            }
        }
        if (((Boolean)SpellsConfig.LOAD_SPELL_TREES.get()).booleanValue()) {
            for (File f : folder.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".json")) continue;
                boolean failed = false;
                JsonElement json = null;
                try {
                    json = SpellsFileUtil.readJsonFromFile(f);
                }
                catch (Exception e) {
                    failed = true;
                    SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath(), (Object)e);
                    e.printStackTrace();
                }
                if (json != null && json.isJsonObject()) {
                    SpellTree t = null;
                    try {
                        t = SpellTreeSerializer.treeFromJson(json.getAsJsonObject());
                        SpellsAndShields.LOGGER.info("Successfully read spell tree from file {}.", (Object)f.toPath());
                    }
                    catch (IllegalStateException e) {
                        SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath(), (Object)e);
                        e.printStackTrace();
                    }
                    if (t == null) continue;
                    LOADED_SPELL_TREES.add(t);
                    continue;
                }
                if (failed) continue;
                SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath());
            }
        }
    }

    private static void availableSpellTrees(AvailableSpellTreesEvent event) {
        LOADED_SPELL_TREES.forEach(tree -> event.addSpellTree(tree.copy()));
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(SpellTrees::availableSpellTrees);
    }
}

