/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.spell.ISpell;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellsFileUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configDir = null;

    public static Path getOrCreateConfigDir() {
        return configDir != null ? configDir : (configDir = FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve("spells_and_shields"), (String)"spells_and_shields"));
    }

    public static Path getOrCreateSubConfigDir(String name) {
        return FileUtils.getOrCreateDirectory((Path)SpellsFileUtil.getOrCreateConfigDir().resolve(name), (String)("spells_and_shields/" + name));
    }

    public static boolean doesSubConfigDirExist(String name) {
        return Files.isDirectory(SpellsFileUtil.getOrCreateConfigDir().resolve(name), new LinkOption[0]);
    }

    public static void writeJsonToFile(File file, JsonElement json) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            GSON.toJson(json, (Appendable)fw);
            fw.flush();
        }
    }

    public static JsonElement readJsonFromFile(File file) throws IOException {
        try (FileReader fr = new FileReader(file);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)fr);
            return jsonElement;
        }
    }

    public static String jsonString(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new IllegalStateException();
        }
        return element.getAsString();
    }

    public static int jsonInt(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalStateException();
        }
        try {
            return element.getAsInt();
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    public static float jsonFloat(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalStateException();
        }
        return element.getAsFloat();
    }

    public static double jsonDouble(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalStateException();
        }
        return element.getAsDouble();
    }

    public static boolean jsonBoolean(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean()) {
            throw new IllegalStateException();
        }
        return element.getAsBoolean();
    }

    public static JsonElement jsonElement(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null) {
            throw new IllegalStateException();
        }
        return element;
    }

    public static JsonObject jsonObject(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonObject()) {
            throw new IllegalStateException();
        }
        return element.getAsJsonObject();
    }

    public static JsonArray jsonArray(JsonObject json, String key) throws IllegalStateException {
        JsonElement element = json.get(key);
        if (element == null || !element.isJsonArray()) {
            throw new IllegalStateException();
        }
        return element.getAsJsonArray();
    }

    public static Item jsonItem(JsonObject json, String key, boolean allowNull) throws IllegalStateException {
        String id = SpellsFileUtil.jsonString(json, key);
        if (id.isEmpty()) {
            if (allowNull) {
                return null;
            }
            throw new IllegalStateException();
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            throw new IllegalStateException(new NullPointerException());
        }
        return item;
    }

    public static Item jsonItem(JsonObject json, String key) throws IllegalStateException {
        return SpellsFileUtil.jsonItem(json, key, false);
    }

    public static void jsonItem(JsonObject json, String key, Item item) throws IllegalStateException {
        json.addProperty(key, item.getRegistryName().toString());
    }

    public static ISpell jsonSpell(JsonObject json, String key, boolean allowNull) throws IllegalStateException {
        String id = SpellsFileUtil.jsonString(json, key);
        if (id.isEmpty()) {
            if (allowNull) {
                return null;
            }
            throw new IllegalStateException();
        }
        ISpell spell = (ISpell)Spells.SPELLS_REGISTRY.get().getValue(new ResourceLocation(id));
        if (spell == null) {
            throw new IllegalStateException(new NullPointerException());
        }
        return spell;
    }

    public static ISpell jsonSpell(JsonObject json, String key) throws IllegalStateException {
        return SpellsFileUtil.jsonSpell(json, key, false);
    }

    public static void jsonSpell(JsonObject json, @Nullable ISpell spell, String key) {
        if (spell == null) {
            json.addProperty(key, "");
        } else {
            json.addProperty(key, spell.getRegistryName().toString());
        }
    }

    public static ItemStack jsonItemStack(JsonObject json, String itemStackObjectKey) throws IllegalStateException {
        JsonObject item = SpellsFileUtil.jsonObject(json, itemStackObjectKey);
        return SpellsFileUtil.jsonItemStack(item);
    }

    public static ItemStack jsonItemStack(JsonObject json) throws IllegalStateException {
        return SpellsFileUtil.jsonItemStack(json, "item", "count");
    }

    public static ItemStack jsonItemStack(JsonObject json, String itemKey, String countKey) throws IllegalStateException {
        Item item = SpellsFileUtil.jsonItem(json, itemKey, true);
        int count = SpellsFileUtil.jsonInt(json, countKey);
        return count <= 0 || item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, count);
    }

    public static void jsonItemStack(JsonObject json, ItemStack itemStack, String itemStackObjectKey) {
        JsonObject item = new JsonObject();
        SpellsFileUtil.jsonItemStack(item, itemStack);
        json.add(itemStackObjectKey, (JsonElement)item);
    }

    public static void jsonItemStack(JsonObject json, ItemStack itemStack) {
        SpellsFileUtil.jsonItemStack(json, itemStack, "item", "count");
    }

    public static void jsonItemStack(JsonObject json, ItemStack itemStack, String itemKey, String countKey) {
        if (itemStack.m_41619_()) {
            json.addProperty(itemKey, "");
            json.addProperty(countKey, (Number)0);
        } else {
            SpellsFileUtil.jsonItem(json, itemKey, itemStack.m_41720_());
            json.addProperty(countKey, (Number)itemStack.m_41613_());
        }
    }
}

