/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.common.collect.ImmutableList;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.spell.ISpell;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellsUtil {
    public static final Optional<ItemStack> EMPTY_ITEMSTACK_OPTIONAL = Optional.of(ItemStack.f_41583_);
    public static final Optional<List<ItemStack>> EMPTY_ITEMSTACK_LIST_OPTIONAL = Optional.of(ImmutableList.of((Object)ItemStack.f_41583_));
    public static final Container EMPTY_CONTAINER = new SimpleContainer(0);

    public static HitResult rayTrace(Level level, Entity source, double maxDist, Predicate<Entity> filter, float bbInflation, ClipContext.Block block, ClipContext.Fluid fluid) {
        BlockHitResult blockHitResult = SpellsUtil.rayTraceBlock(level, source, maxDist, block, fluid);
        EntityHitResult entityHitResult = SpellsUtil.rayTraceEntity(level, source, maxDist, filter, bbInflation);
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return entityHitResult;
        }
        Vec3 position = source.m_20182_();
        double blockDist = blockHitResult.m_82448_(source);
        double entityDist = entityHitResult.m_82448_(source);
        if (entityDist <= blockDist) {
            return entityHitResult;
        }
        return blockHitResult;
    }

    public static BlockHitResult rayTraceBlock(Level level, Entity source, double maxDist, ClipContext.Block block, ClipContext.Fluid fluid) {
        double maxDistSqr = maxDist * maxDist;
        Vec3 start = source.m_146892_();
        Vec3 direction = source.m_20252_(1.0f).m_82541_();
        Vec3 end = start.m_82549_(direction.m_82490_(maxDist));
        return level.m_45547_(new ClipContext(start, end, block, fluid, source));
    }

    @Nullable
    public static EntityHitResult rayTraceEntity(Level level, Entity source, double maxDist, Predicate<Entity> filter, float bbInflation) {
        double maxDistSqr = maxDist * maxDist;
        double currentDistance = Double.MAX_VALUE;
        Entity currentEntity = null;
        Vec3 start = source.m_146892_();
        Vec3 direction = source.m_20252_(1.0f).m_82541_();
        Vec3 end = start.m_82549_(direction.m_82490_(maxDist));
        for (Entity entity : level.m_45933_(source, AABB.m_165882_((Vec3)start, (double)maxDistSqr, (double)maxDistSqr, (double)maxDistSqr))) {
            double distance;
            AABB aabb;
            Optional optional;
            if (!filter.test(entity) || !(optional = (aabb = entity.m_142469_().m_82400_((double)bbInflation)).m_82371_(start, end)).isPresent() || !((distance = start.m_82557_((Vec3)optional.get())) < currentDistance)) continue;
            currentEntity = entity;
            currentDistance = distance;
        }
        return currentEntity == null ? null : new EntityHitResult(currentEntity);
    }

    public static ISpell getSpell(ResourceLocation key) {
        return (ISpell)Spells.SPELLS_REGISTRY.get().getValue(key);
    }

    public static void forEachSpell(Consumer<ISpell> consumer) {
        Spells.SPELLS_REGISTRY.get().forEach(consumer);
    }

    public static int getSpellsAmount() {
        return Spells.SPELLS_REGISTRY.get().getValues().size();
    }

    public static UUID generateUUIDFromName(String purpose, String name) {
        return UUID.nameUUIDFromBytes(("spells_and_shields_" + purpose + "_" + name).getBytes(StandardCharsets.UTF_8));
    }

    public static UUID generateUUIDForTree(String name) {
        return SpellsUtil.generateUUIDFromName("tree", name);
    }

    public static UUID generateUUIDForSlotAttribute(Attribute attribute, int slot) {
        return SpellsUtil.generateUUIDFromName("slot_" + slot, attribute.getRegistryName().toString());
    }

    public static UUID generateUUIDForClassAttribute(Attribute attribute, String className) {
        return SpellsUtil.generateUUIDFromName("class_" + className, attribute.getRegistryName().toString());
    }

    public static void addPotionRecipes(Potion base, Potion p, @Nullable Potion strongP, @Nullable Potion longP, Item ingredient, @Nullable Potion badP, @Nullable Potion badStrongP, @Nullable Potion badLongP, @Nullable Item badIngredient) {
        SpellsUtil.addPotionRecipe(ingredient, base, p);
        if (badP != null && badIngredient != null) {
            SpellsUtil.addPotionRecipe(badIngredient, p, badP);
            if (badStrongP != null) {
                SpellsUtil.addPotionRecipe(Items.f_42525_, badP, badStrongP);
            }
            if (badLongP != null) {
                SpellsUtil.addPotionRecipe(Items.f_42451_, badP, badLongP);
            }
        }
        if (strongP != null) {
            SpellsUtil.addPotionRecipe(Items.f_42525_, p, strongP);
            if (badStrongP != null && badIngredient != null) {
                SpellsUtil.addPotionRecipe(badIngredient, strongP, badStrongP);
            }
        }
        if (longP != null) {
            SpellsUtil.addPotionRecipe(Items.f_42451_, p, longP);
            if (badLongP != null && badIngredient != null) {
                SpellsUtil.addPotionRecipe(badIngredient, longP, badLongP);
            }
        }
    }

    public static void addPotionRecipe(Item ingredient, Potion from, Potion to) {
        PotionBrewing.m_43513_((Potion)from, (Item)ingredient, (Potion)to);
    }

    public static boolean isEnchantingTable(Block block) {
        return block != null && SpellsUtil.isEnchantingTable(block.getRegistryName());
    }

    public static boolean isEnchantingTable(ResourceLocation key) {
        return key != null && ((List)SpellsConfig.ENCHANTING_TABLE.get()).stream().anyMatch(rl -> rl.equals(key.toString()));
    }
}

