/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.IManaHolder;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.enchantment.ManaRegenEnchantment;
import de.cas_ual_ty.spells.enchantment.MaxManaEnchantment;
import de.cas_ual_ty.spells.network.ManaSyncMessage;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class ManaHolder
implements IManaHolder {
    public static final int TICKS_UNTIL_REG = 50;
    protected float mana = 0.0f;
    protected float extraMana = 0.0f;
    protected float lastSentMana = -1.0f;
    protected float lastSentExtraMana = -1.0f;
    public int regenTime = 0;
    public int ticksUntilNextReg = this.calcTicksUntilReg();
    public int changeTime = -1;
    protected final LivingEntity player;

    public ManaHolder(LivingEntity player) {
        this.player = player;
    }

    @Override
    public void setMana(float mana) {
        this.mana = mana;
        this.checkSyncStatus();
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public void setExtraMana(float extraMana) {
        this.extraMana = extraMana;
        if (this.extraMana < 0.0f) {
            this.extraMana = 0.0f;
        }
        this.checkSyncStatus();
    }

    @Override
    public float getExtraMana() {
        return this.extraMana;
    }

    @Override
    public void replenish(float amount) {
        this.mana += amount;
        float maxMana = this.getMaxMana();
        if (this.mana > maxMana) {
            this.mana = maxMana;
        }
        this.checkSyncStatus();
    }

    @Override
    public void burn(float amount) {
        boolean wasFull;
        boolean bl = wasFull = this.mana >= this.getMaxMana();
        if (this.extraMana > 0.0f) {
            this.extraMana -= amount;
            if (this.extraMana < 0.0f) {
                amount = -this.extraMana;
                this.extraMana = 0.0f;
            } else {
                amount = 0.0f;
            }
        }
        this.mana -= amount;
        if (this.mana < 0.0f) {
            this.mana = 0.0f;
        }
        if (wasFull) {
            this.regenTime = 0;
        }
        this.checkSyncStatus();
    }

    @Override
    public LivingEntity getPlayer() {
        return this.player;
    }

    public float getMaxMana() {
        AttributeInstance attrMana = this.player.m_21051_((Attribute)SpellsRegistries.MAX_MANA_ATTRIBUTE.get());
        double attribute = attrMana == null ? 0.0 : attrMana.m_22135_();
        for (EquipmentSlot s : EquipmentSlot.values()) {
            if (s.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack itemStack = this.player.m_6844_(s);
            int level = itemStack.getEnchantmentLevel((Enchantment)SpellsRegistries.MAX_MANA_ENCHANTMENT.get());
            double increase = ((MaxManaEnchantment)((Object)SpellsRegistries.MAX_MANA_ENCHANTMENT.get())).getAttributeIncrease(level);
            attribute += increase;
        }
        return (float)attribute;
    }

    public void tick() {
        if (this.changeTime > 0) {
            --this.changeTime;
        }
        ++this.regenTime;
        if (this.regenTime >= this.ticksUntilNextReg || this.getMana() > this.getMaxMana()) {
            this.replenish(1.0f);
            this.regenTime = 0;
            this.ticksUntilNextReg = this.calcTicksUntilReg();
        }
    }

    protected int calcTicksUntilReg() {
        if (!(this.player instanceof Player)) {
            return 50;
        }
        Player player = (Player)this.player;
        double attribute = player.m_21133_((Attribute)SpellsRegistries.MANA_REGEN_ATTRIBUTE.get());
        for (EquipmentSlot s : EquipmentSlot.values()) {
            if (s.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack itemStack = player.m_6844_(s);
            int level = itemStack.getEnchantmentLevel((Enchantment)SpellsRegistries.MANA_REGEN_ENCHANTMENT.get());
            double increase = ((ManaRegenEnchantment)((Object)SpellsRegistries.MANA_REGEN_ENCHANTMENT.get())).getAttributeIncrease(level);
            attribute += increase;
        }
        if (attribute <= 0.0) {
            return Integer.MAX_VALUE;
        }
        return Mth.m_14165_((double)(50.0 / attribute));
    }

    public void checkSyncStatus() {
        if (this.mana != this.lastSentMana || this.extraMana != this.lastSentExtraMana) {
            this.changeTime = 20;
            this.lastSentMana = this.mana;
            this.lastSentExtraMana = this.extraMana;
            if (this.player.f_19853_.f_46443_) {
                return;
            }
            this.sendSync();
        }
    }

    public ManaSyncMessage makeSyncMessage() {
        return new ManaSyncMessage(this.player.m_19879_(), this.mana, this.extraMana);
    }

    public ListTag serializeNBT() {
        ListTag tag = new ListTag();
        tag.add(0, (Tag)FloatTag.m_128566_((float)this.mana));
        tag.add(1, (Tag)FloatTag.m_128566_((float)this.extraMana));
        return tag;
    }

    public void deserializeNBT(ListTag tag) {
        if (tag.get(0).m_7060_() == 5 && tag.get(1).m_7060_() == 5) {
            this.mana = tag.m_128775_(0);
            this.extraMana = tag.m_128775_(1);
        }
    }

    @Override
    public void sendSync() {
        LivingEntity livingEntity = this.player;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SpellsAndShields.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)this.makeSyncMessage());
        }
    }

    public static LazyOptional<ManaHolder> getManaHolder(LivingEntity entity) {
        return entity.getCapability(SpellsCapabilities.MANA_CAPABILITY).cast();
    }
}

