/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.client.SpellKeyBindings;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.spell.ISpell;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;

public class LangGen
extends LanguageProvider {
    public static final String PASSIVE_STRING = "A passive effect.";

    public LangGen(DataGenerator dataGen, String locale) {
        super(dataGen, "spells_and_shields", locale);
    }

    protected void addTranslations() {
        this.addAttribute((Supplier<? extends Attribute>)SpellsRegistries.MAX_MANA_ATTRIBUTE, "Max Mana");
        this.addEnchantment((Supplier)SpellsRegistries.MAGIC_PROTECTION_ENCHANTMENT, "Magic Protection");
        this.addEnchantment((Supplier)SpellsRegistries.MANA_BLADE_ENCHANTMENT, "Mana Blade");
        this.addEnchantment((Supplier)SpellsRegistries.MANA_SHIELD_ENCHANTMENT, "Mana Shield");
        this.addEnchantment((Supplier)SpellsRegistries.MANA_REGEN_ENCHANTMENT, "Mana Regeneration");
        this.addEnchantment((Supplier)SpellsRegistries.MAX_MANA_ENCHANTMENT, "Maximum Mana");
        this.addEffect((Supplier)SpellsRegistries.INSTANT_MANA_EFFECT, "Instant Mana");
        this.addEffect((Supplier)SpellsRegistries.MANA_BOMB_EFFECT, "Mana Bomb");
        this.addEffect((Supplier)SpellsRegistries.REPLENISHMENT_EFFECT, "Replenishment");
        this.addEffect((Supplier)SpellsRegistries.LEAKING_MOB_EFFECT, "Leaking");
        this.addEffect((Supplier)SpellsRegistries.MANA_BOOST_EFFECT, "Mana Boost");
        this.addEffect((Supplier)SpellsRegistries.EXTRA_MANA_EFFECT, "Extra Mana");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.LONG_LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)SpellsRegistries.STRONG_LEAKING, "Leaking");
        this.add("key.spells_and_shields.categories.spell_slots", "Spells & Shields");
        for (int i = 0; i < 5; ++i) {
            this.add(SpellKeyBindings.key(i), "Spell Slot " + (i + 1));
        }
        this.addSpell((Supplier<? extends ISpell>)Spells.FIRE_BALL, "Fire Ball", "Shoot a fire ball forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.LEAP, "Leap", "Leap forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.SUMMON_ANIMAL, "Summon Animal", "Create life based on the item in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.BLOW_ARROW, "Blow Arrow", "Shoot a projectile from your hand without a bow.");
        this.addSpell((Supplier<? extends ISpell>)Spells.BLAST_SMELT, "Blast Smelt", "Works like an instant blast furnace on the item in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.HEALTH_BOOST, "Health Boost", "Increases your maximum health.");
        this.addSpell((Supplier<? extends ISpell>)Spells.MANA_BOOST, "Mana Boost", "Increases your maximum mana.");
        this.addSpell((Supplier<? extends ISpell>)Spells.SPEED, "Speed", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.JUMP_BOOST, "Jump Boost", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.DOLPHINS_GRACE, "Dolphin's Grace", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.WATER_LEAP, "Water Leap", "Leap forward like a dolphin (must be underwater).");
        this.addSpell((Supplier<? extends ISpell>)Spells.AQUA_AFFINITY, "Aqua Affinity", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.WATER_BREATHING, "Water Breathing", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.SLOW_FALLING, "Slow Falling", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.HASTE, "Haste", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.REGENERATION, "Regeneration", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.REPLENISHMENT, "Replenishment", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.WATER_WHIP, "Water Whip", "Shoots water out of the water bucket in your hand. The water returns and the bucket refills if you hold it on return.");
        this.addSpell((Supplier<? extends ISpell>)Spells.POTION_SHOT, "Potion Shot", "Shots the contents of the potion in your hand forward.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FROST_WALKER, "Frost Walker", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.JUMP, "Jump", "High jump. Be aware of fall damage.");
        this.addSpell((Supplier<? extends ISpell>)Spells.MANA_SOLES, "Mana Soles", "Consumes mana to reduce or cancel fall damage.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FIRE_CHARGE, "Fire Charge", "Shoot a fire charge forward, like a Ghast.");
        this.addSpell((Supplier<? extends ISpell>)Spells.PRESSURIZE, "Pressurize", "Knock back every entity around you and remove any fluid.");
        this.addSpell((Supplier<? extends ISpell>)Spells.INSTANT_MINE, "Instant Mine", "Breaks the block your are looking at using the tool in your hand.");
        this.addSpell((Supplier<? extends ISpell>)Spells.FIRE_RESISTANCE, "Fire Resistance", PASSIVE_STRING);
        this.addSpell((Supplier<? extends ISpell>)Spells.SPIT_METAL, "Spit Metal", "Spit a nugget that deals damage (from your hand).");
        this.add("spell_tree.nether", "Nether");
        this.add("spell_tree.ocean", "Ocean");
        this.add("spell_tree.mining", "Mining");
        this.add("spell_tree.movement", "Movement");
        this.add(SpellProgressionMenu.TITLE.getString(), "Spell Progression");
        this.add("spells.progression.learn.success.single", "%s has been learned by %s");
        this.add("spells.progression.learn.success.multiple", "%s has been learned by %s players");
        this.add("spells.progression.learn_all.success.single", "%s spells have been learned by %s");
        this.add("spells.progression.learn_all.failed.single", "%s already learned all spells");
        this.add("spells.progression.learn_all.success.multiple", "All %s habe been learned by %s players");
        this.add("spells.progression.forget.success.single", "%s has been forgotten by %s");
        this.add("spells.progression.forget.success.multiple", "%s has been forgotten by %s players");
        this.add("spells.progression.forget_all.success.single", "%s spells have been forgotten by %s");
        this.add("spells.progression.forget_all.failed.single", "%s has never learned a single spell");
        this.add("spells.progression.forget_all.success.multiple", "All %s spells have been forgotten by %s players");
        this.add("spells.progression.reset.success.single", "Cleared all learned spells of %s");
        this.add("spells.progression.reset.success.multiple", "Cleared all learned spells of %s players");
        this.add("spells.slot.remove.success.single", "Cleared active spell in slot %s of %s");
        this.add("spells.slot.remove.success.multiple", "Cleared active spell in slot %s of %s players");
        this.add("spells.slot.set.success.single", "Set active spell in slot %s of %s to %s");
        this.add("spells.slot.set.success.multiple", "Set active spell in slot %s of %s players to %s");
        this.add("spells.slot.clear.success.single", "Cleared active spells of %s");
        this.add("spells.slot.clear.success.multiple", "Cleared active spells of %s players");
        this.add("spell.ingredients.hand", "Requirement (Hand):");
        this.add("spell.ingredients.inventory", "Requirement (Inventory):");
        this.add("spell.passive.when_applied", "When Applied:");
        this.add("spell_progression.learn", "Learn");
        this.add("spell_progression.equip", "Equip");
        this.add("spell_progression.unavailable", "Unavailable");
        this.add("spell_progression.choose", "Choose a Slot");
    }

    public void addAttribute(Supplier<? extends Attribute> key, String name) {
        this.add(key.get().m_22087_(), name);
    }

    public void addPotion(Supplier<? extends Potion> key, String name) {
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)key.get()), "Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)key.get()), "Splash Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)key.get()), "Lingering Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)key.get()), "Arrow of " + name);
    }

    public void addSpell(Supplier<? extends ISpell> key, String name, String desc) {
        this.add(key.get().getNameKey(), name);
        this.add(key.get().getDescKey(), desc);
    }
}

