/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.HomingSpellProjectile;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public interface IReturnProjectileSpell
extends IProjectileSpell {
    public static final String KEY_DIRECTION = "Direction";
    public static final String DEPART = "Depart";
    public static final String RETURN = "Return";

    default public boolean onEntityHitDeparture(SpellProjectile entity, EntityHitResult entityHitResult) {
        entity.m_146870_();
        return true;
    }

    default public void onEntityHitReturn(SpellProjectile entity, EntityHitResult entityHitResult) {
        entity.m_146870_();
    }

    default public boolean onBlockHitDeparture(SpellProjectile entity, BlockHitResult blockHitResult) {
        entity.m_146870_();
        return true;
    }

    default public void onBlockHitReturn(SpellProjectile entity, BlockHitResult blockHitResult) {
    }

    @Override
    default public void onEntityHit(SpellProjectile entity, EntityHitResult entityHitResult) {
        String direction = entity.getSpellDataTag().m_128461_(KEY_DIRECTION);
        if (DEPART.equals(direction)) {
            if (this.onEntityHitDeparture(entity, entityHitResult)) {
                this.shootReturning(entity);
            }
        } else if (RETURN.equals(direction)) {
            this.onEntityHitReturn(entity, entityHitResult);
        }
    }

    @Override
    default public void onBlockHit(SpellProjectile entity, BlockHitResult blockHitResult) {
        String direction = entity.getSpellDataTag().m_128461_(KEY_DIRECTION);
        if (DEPART.equals(direction)) {
            if (this.onBlockHitDeparture(entity, blockHitResult)) {
                this.shootReturning(entity);
            }
        } else if (RETURN.equals(direction)) {
            this.onBlockHitReturn(entity, blockHitResult);
        }
    }

    @Override
    default public void onTimeout(SpellProjectile entity) {
        String direction = entity.getSpellDataTag().m_128461_(KEY_DIRECTION);
        if (DEPART.equals(direction)) {
            this.shootReturning(entity);
        }
    }

    default public float getReturnVelocity() {
        return 2.0f;
    }

    @Override
    default public void shootStraight(ManaHolder manaHolder, float inaccuracy, BiConsumer<SpellProjectile, ServerLevel> followUp) {
        IProjectileSpell.super.shootStraight(manaHolder, inaccuracy, (projectile, level) -> projectile.getSpellDataTag().m_128359_(KEY_DIRECTION, DEPART));
    }

    @Override
    default public void shootHoming(ManaHolder manaHolder, Entity target, BiConsumer<HomingSpellProjectile, ServerLevel> followUp) {
        IProjectileSpell.super.shootHoming(manaHolder, target, (projectile, level) -> projectile.getSpellDataTag().m_128359_(KEY_DIRECTION, DEPART));
    }

    default public void shootReturning(SpellProjectile entity, BiConsumer<HomingSpellProjectile, ServerLevel> followUp) {
        if (entity.m_37282_() != null) {
            Entity owner = entity.m_37282_();
            HomingSpellProjectile.home(entity.m_20182_(), owner.m_20182_().m_82546_(entity.m_20182_()), entity.m_37282_(), entity.m_37282_(), this, this.getReturnVelocity(), (entity2, level) -> {
                for (String key : entity.getSpellDataTag().m_128431_()) {
                    entity2.getSpellDataTag().m_128365_(key, entity.getSpellDataTag().m_128423_(key));
                }
                entity2.getSpellDataTag().m_128359_(KEY_DIRECTION, RETURN);
            });
        }
    }

    default public void shootReturning(SpellProjectile entity) {
        this.shootReturning(entity, (projectile, level) -> {});
    }
}

