/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.Spell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class MultiIngredientSpell
extends Spell {
    public static final String KEY_REQUIRED_HAND = "spell.ingredients.hand";
    public static final String KEY_REQUIRED_INVENTORY = "spell.ingredients.inventory";

    public MultiIngredientSpell(float manaCost) {
        super(manaCost);
    }

    public void perform(ManaHolder manaHolder, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients) {
        this.perform(manaHolder);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
    }

    @Override
    public boolean activate(ManaHolder manaHolder) {
        if (this.canActivate(manaHolder)) {
            Optional<List<ItemStack>> handIngredients = this.hasHandIngredients(manaHolder);
            Optional<List<ItemStack>> inventoryIngredients = this.hasInventoryIngredients(manaHolder);
            if (handIngredients.isPresent() && inventoryIngredients.isPresent()) {
                Player player;
                LivingEntity livingEntity;
                this.perform(manaHolder, handIngredients.get(), inventoryIngredients.get());
                if (!(manaHolder.getPlayer().f_19853_.f_46443_ || (livingEntity = manaHolder.getPlayer()) instanceof Player && (player = (Player)livingEntity).m_7500_())) {
                    this.burnMana(manaHolder);
                    this.consumeItemStacks(manaHolder, handIngredients.get(), inventoryIngredients.get());
                    return true;
                }
            }
        }
        return false;
    }

    public List<ItemStack> findHandIngredients(ManaHolder manaHolder) {
        LinkedList<ItemStack> foundList = new LinkedList<ItemStack>();
        block0: for (ItemStack required : this.getRequiredHandIngredients()) {
            for (ItemStack toTest : manaHolder.getPlayer().m_6167_()) {
                if (!this.checkHandIngredient(manaHolder, required, toTest)) continue;
                foundList.add(toTest);
                continue block0;
            }
        }
        return foundList;
    }

    public List<ItemStack> findInventoryIngredients(ManaHolder manaHolder) {
        LinkedList<ItemStack> foundList = new LinkedList<ItemStack>();
        LivingEntity livingEntity = manaHolder.getPlayer();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            block0: for (ItemStack required : this.getRequiredInventoryIngredients()) {
                for (ItemStack toTest : player.m_150109_().f_35974_) {
                    if (toTest == player.m_21205_() || !this.checkInventoryIngredient(manaHolder, required, toTest)) continue;
                    foundList.add(toTest);
                    continue block0;
                }
            }
        }
        return foundList;
    }

    public Optional<List<ItemStack>> hasHandIngredients(ManaHolder manaHolder) {
        List<ItemStack> handIngredients = this.findHandIngredients(manaHolder);
        return this.getRequiredHandIngredients().size() == handIngredients.size() ? Optional.of(handIngredients) : Optional.empty();
    }

    public Optional<List<ItemStack>> hasInventoryIngredients(ManaHolder manaHolder) {
        if (manaHolder.getPlayer() instanceof Player) {
            List<ItemStack> inventoryIngredients = this.findInventoryIngredients(manaHolder);
            return this.getRequiredInventoryIngredients().size() == inventoryIngredients.size() ? Optional.of(inventoryIngredients) : Optional.empty();
        }
        return SpellsUtil.EMPTY_ITEMSTACK_LIST_OPTIONAL;
    }

    public abstract List<ItemStack> getRequiredHandIngredients();

    public abstract List<ItemStack> getRequiredInventoryIngredients();

    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack required, ItemStack toTest) {
        return required.m_41619_() || toTest.m_41720_() == required.m_41720_() && toTest.m_41613_() >= required.m_41613_();
    }

    public boolean checkInventoryIngredient(ManaHolder manaHolder, ItemStack required, ItemStack toTest) {
        return required.m_41619_() || toTest.m_41720_() == required.m_41720_() && toTest.m_41613_() >= required.m_41613_();
    }

    public abstract void consumeItemStacks(ManaHolder var1, List<ItemStack> var2, List<ItemStack> var3);

    @Override
    public void addSpellDesc(List<Component> list) {
        super.addSpellDesc(list);
        List<ItemStack> handIngredients = this.getRequiredHandIngredients();
        List<ItemStack> inventoryIngredients = this.getRequiredInventoryIngredients();
        if (!handIngredients.isEmpty()) {
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)KEY_REQUIRED_HAND).m_130940_(ChatFormatting.BLUE));
            handIngredients.stream().map(itemStack -> Component.m_237113_((String)" ").m_7220_(itemStack.m_41786_()).m_130940_(ChatFormatting.YELLOW)).forEach(list::add);
        }
        if (!inventoryIngredients.isEmpty()) {
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)KEY_REQUIRED_INVENTORY).m_130940_(ChatFormatting.BLUE));
            inventoryIngredients.stream().map(itemStack -> Component.m_237113_((String)" ").m_7220_(itemStack.m_41786_()).m_130940_(ChatFormatting.YELLOW)).forEach(list::add);
        }
    }
}

