/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IConfigurableSpell;
import de.cas_ual_ty.spells.spell.base.BaseSpell;
import de.cas_ual_ty.spells.util.ManaTooltipComponent;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public abstract class Spell
extends BaseSpell
implements IConfigurableSpell {
    public final float defaultManaCost;
    protected float manaCost;
    protected Optional<TooltipComponent> tooltipComponent;

    public Spell(float manaCost) {
        this.defaultManaCost = manaCost;
    }

    public float getManaCost() {
        return this.manaCost;
    }

    public abstract void perform(ManaHolder var1);

    @Override
    public boolean activate(ManaHolder manaHolder) {
        if (this.canActivate(manaHolder)) {
            this.perform(manaHolder);
            manaHolder.burn(this.manaCost);
            return true;
        }
        return false;
    }

    public boolean canActivate(ManaHolder manaHolder) {
        Player player;
        LivingEntity livingEntity;
        return manaHolder.getMana() + manaHolder.getExtraMana() >= this.manaCost || (livingEntity = manaHolder.getPlayer()) instanceof Player && (player = (Player)livingEntity).m_7500_();
    }

    public void burnMana(ManaHolder manaHolder) {
        if (!manaHolder.getPlayer().f_19853_.f_46443_) {
            manaHolder.burn(this.manaCost);
        }
    }

    @Override
    public Optional<TooltipComponent> getTooltipComponent() {
        return this.tooltipComponent;
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("manaCost", (Number)Float.valueOf(this.defaultManaCost));
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.manaCost = SpellsFileUtil.jsonFloat(json, "manaCost");
        if (this.manaCost > 0.0f) {
            this.tooltipComponent = Optional.of(new ManaTooltipComponent(this.manaCost));
        }
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.manaCost = this.defaultManaCost;
        if (this.manaCost > 0.0f) {
            this.tooltipComponent = Optional.of(new ManaTooltipComponent(this.manaCost));
        }
    }
}

