/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SpellProjectile
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    protected IProjectileSpell spell;
    protected CompoundTag spellDataTag = new CompoundTag();

    public SpellProjectile(EntityType<? extends SpellProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpellProjectile(EntityType<? extends SpellProjectile> entityType, Level level, IProjectileSpell spell) {
        this(entityType, level);
        this.spell = spell;
    }

    protected float m_6884_() {
        return this.spell != null ? this.spell.getInertia() : 1.0f;
    }

    protected ParticleOptions m_5967_() {
        return this.spell != null ? this.spell.getTrailParticle() : ParticleTypes.f_123759_;
    }

    public void m_8119_() {
        super.m_8119_();
        IProjectileSpell spell = this.getSpell();
        spell.tick(this);
        if (this.f_19797_ >= spell.getTimeout() && !this.f_19853_.f_46443_) {
            spell.onTimeout(this);
            this.m_146870_();
        }
    }

    @NotNull
    public CompoundTag getSpellDataTag() {
        return this.spellDataTag;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        IProjectileSpell spell = this.getSpell();
        spell.onEntityHit(this, entityHitResult);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        IProjectileSpell spell = this.getSpell();
        spell.onBlockHit(this, blockHitResult);
    }

    public boolean m_5931_() {
        return false;
    }

    public IProjectileSpell getSpell() {
        return this.spell;
    }

    public void setSpell(IProjectileSpell spell) {
        this.spell = spell;
    }

    public static void shoot(Entity source, IProjectileSpell spell, float velocity, float inaccuracy, BiConsumer<SpellProjectile, ServerLevel> followUp) {
        Level level = source.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Vec3 position = source.m_146892_();
            Vec3 direction = source.m_20252_(1.0f).m_82541_();
            SpellProjectile projectile = new SpellProjectile((EntityType<? extends SpellProjectile>)((EntityType)SpellsRegistries.SPELL_PROJECTILE.get()), (Level)level2, spell);
            projectile.m_5602_(source);
            projectile.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, source.m_146909_(), source.m_146908_());
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, inaccuracy);
            level2.m_7967_((Entity)projectile);
            followUp.accept(projectile, level2);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeRegistryId(Spells.SPELLS_REGISTRY.get(), (Object)this.getSpell());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.spell = (IProjectileSpell)buf.readRegistryId();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("SpellData", (Tag)this.spellDataTag);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.spellDataTag = nbt.m_128441_("SpellData") ? nbt.m_128469_("SpellData") : new CompoundTag();
    }
}

