/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.HandIngredientSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.EntityHitResult;

public class PotionShotSpell
extends HandIngredientSpell
implements IProjectileSpell {
    public static final String KEY_EFFECTS = "Effects";

    public PotionShotSpell(float manaCost) {
        super(manaCost);
    }

    @Override
    public void perform(ManaHolder manaHolder, ItemStack itemStack) {
        this.shootStraight(manaHolder, (projectile, level) -> {
            List effects = PotionUtils.m_43547_((ItemStack)itemStack);
            ListTag tags = new ListTag();
            for (MobEffectInstance effect : effects) {
                tags.add((Object)effect.m_19555_(new CompoundTag()));
            }
            projectile.getSpellDataTag().m_128365_(KEY_EFFECTS, (Tag)tags);
        });
    }

    @Override
    public void onEntityHit(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity entity2 = entityHitResult.m_82443_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            Tag tag2 = entity.getSpellDataTag().m_128423_(KEY_EFFECTS);
            if (tag2 instanceof ListTag) {
                ListTag tags = (ListTag)tag2;
                tags.stream().filter(tag -> tag instanceof CompoundTag).map(tag -> MobEffectInstance.m_19560_((CompoundTag)((CompoundTag)tag))).filter(e -> e != null).forEach(arg_0 -> ((LivingEntity)target).m_7292_(arg_0));
            }
            IProjectileSpell.super.onEntityHit(entity, entityHitResult);
        }
    }

    @Override
    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack itemStack) {
        return itemStack.m_41720_() == Items.f_42589_;
    }

    @Override
    public void consumeItemStack(ManaHolder manaHolder, ItemStack itemStack) {
        if (manaHolder.getPlayer().m_21205_() == itemStack) {
            manaHolder.getPlayer().m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42590_));
        } else if (manaHolder.getPlayer().m_21206_() == itemStack) {
            manaHolder.getPlayer().m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42590_));
        }
    }

    @Override
    public void tick(SpellProjectile entity) {
    }
}

