/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.IProjectileSpell;
import de.cas_ual_ty.spells.spell.base.HandIngredientSpell;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.phys.EntityHitResult;

public class SpitMetalSpell
extends HandIngredientSpell
implements IProjectileSpell {
    public final float defaultBaseDamage;
    public final Map<Item, Float> defaultIngredientMap;
    protected float baseDamage;
    protected Map<Item, Float> ingredientMap;

    public SpitMetalSpell(float manaCost, float baseDamage, Map<Item, Float> ingredientMap) {
        super(manaCost);
        this.defaultBaseDamage = baseDamage;
        this.defaultIngredientMap = ingredientMap;
        this.ingredientMap = new HashMap<Item, Float>();
    }

    public SpitMetalSpell(float manaCost) {
        super(manaCost);
        this.defaultBaseDamage = 4.0f;
        this.ingredientMap = new HashMap<Item, Float>();
        this.ingredientMap.put(Items.f_42749_, Float.valueOf(Tiers.IRON.m_6631_()));
        this.ingredientMap.put(Items.f_42587_, Float.valueOf(Tiers.GOLD.m_6631_()));
        this.defaultIngredientMap = ImmutableMap.copyOf(this.ingredientMap);
        this.ingredientMap.clear();
    }

    @Override
    public void perform(ManaHolder manaHolder, ItemStack itemStack) {
        float damage = this.ingredientMap.getOrDefault(itemStack.m_41720_(), Float.valueOf(0.0f)).floatValue();
        this.shootStraight(manaHolder, (projectile, level) -> {
            level.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_12098_, SoundSource.PLAYERS, 1.0f, 1.0f);
            projectile.getSpellDataTag().m_128350_("materialDamage", damage);
        });
    }

    @Override
    public void onEntityHit(SpellProjectile entity, EntityHitResult entityHitResult) {
        Entity hit = entityHitResult.m_82443_();
        if (hit instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hit;
            livingEntity.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)entity.m_37282_()), entity.getSpellDataTag().m_128457_("materialDamage"));
        }
        IProjectileSpell.super.onEntityHit(entity, entityHitResult);
    }

    @Override
    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack itemStack) {
        return this.ingredientMap.containsKey(itemStack.m_41720_());
    }

    @Override
    public void consumeItemStack(ManaHolder manaHolder, ItemStack itemStack) {
        itemStack.m_41774_(1);
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("baseDamage", (Number)Float.valueOf(this.defaultBaseDamage));
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.baseDamage = SpellsFileUtil.jsonFloat(json, "baseDamage");
        this.ingredientMap.putAll(this.defaultIngredientMap);
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.baseDamage = this.defaultBaseDamage;
        this.ingredientMap.putAll(this.defaultIngredientMap);
    }
}

