/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.spell.ISpell;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class SpellNode {
    protected final ISpell spell;
    protected int levelCost;
    protected int requiredBookshelves;
    protected SpellNode parent;
    protected LinkedList<SpellNode> children;

    public SpellNode(ISpell spell, int levelCost, int requiredBookshelves) {
        this.spell = spell;
        this.levelCost = Math.max(0, levelCost);
        this.requiredBookshelves = Math.max(0, Math.min(32, requiredBookshelves));
        this.children = new LinkedList();
    }

    public ISpell getSpell() {
        return this.spell;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public int getRequiredBookshelves() {
        return this.requiredBookshelves;
    }

    public void setLevelCost(int levelCost) {
        this.levelCost = levelCost;
    }

    public void setRequiredBookshelves(int requiredBookshelves) {
        this.requiredBookshelves = requiredBookshelves;
    }

    public void setParent(@Nullable SpellNode parent) {
        this.parent = parent;
    }

    public void addChild(SpellNode child) {
        this.children.add(child);
    }

    public SpellNode copy() {
        return new SpellNode(this.spell, this.levelCost, this.requiredBookshelves);
    }

    @Nullable
    public SpellNode getParent() {
        return this.parent;
    }

    public LinkedList<SpellNode> getChildren() {
        return this.children;
    }
}

