/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import com.google.gson.JsonElement;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.event.AvailableSpellTreesEvent;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellTreeSerializer;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;

public class SpellTrees {
    public static final List<SpellTree> LOADED_SPELL_TREES = new ArrayList<SpellTree>();
    public static final String KEY_NETHER = "spell_tree.nether";
    public static final String KEY_OCEAN = "spell_tree.ocean";
    public static final String KEY_MINING = "spell_tree.mining";
    public static final String KEY_MOVEMENT = "spell_tree.movement";

    public static List<SpellTree> getBaseTrees() {
        ArrayList<SpellTree> list = new ArrayList<SpellTree>(4);
        list.add(SpellTrees.fireTree());
        list.add(SpellTrees.waterTree());
        list.add(SpellTrees.earthTree());
        list.add(SpellTrees.airTree());
        return list;
    }

    public static SpellTree fireTree() {
        return SpellTree.builder(SpellsUtil.generateUUIDForTree("nether"), Spells.FIRE_BALL, 15, 28, (Component)Component.m_237115_((String)KEY_NETHER)).icon((ISpell)Spells.FIRE_RESISTANCE.get()).add((Supplier<ISpell>)Spells.FIRE_RESISTANCE, 30, 30).leaf().add((Supplier<ISpell>)Spells.FIRE_CHARGE, 10, 28).finish();
    }

    public static SpellTree waterTree() {
        return SpellTree.builder(SpellsUtil.generateUUIDForTree("ocean"), Spells.WATER_BREATHING, 10, 0, (Component)Component.m_237115_((String)KEY_OCEAN)).icon((ISpell)Spells.DOLPHINS_GRACE.get()).add((Supplier<ISpell>)Spells.REGENERATION, 20, 20).add((Supplier<ISpell>)Spells.AQUA_AFFINITY, 20, 20).leaf().leaf().add((Supplier<ISpell>)Spells.WATER_LEAP, 5, 10).add((Supplier<ISpell>)Spells.DOLPHINS_GRACE, 30, 30).leaf().add((Supplier<ISpell>)Spells.FROST_WALKER, 10, 14).leaf().leaf().add((Supplier<ISpell>)Spells.WATER_WHIP, 10, 10).add((Supplier<ISpell>)Spells.POTION_SHOT, 10, 10).finish();
    }

    public static SpellTree earthTree() {
        return SpellTree.builder(SpellsUtil.generateUUIDForTree("mining"), Spells.BLAST_SMELT, 5, 8, (Component)Component.m_237115_((String)KEY_MINING)).icon((ISpell)Spells.HASTE.get()).add((Supplier<ISpell>)Spells.INSTANT_MINE, 15, 18).add((Supplier<ISpell>)Spells.HASTE, 25, 24).leaf().leaf().add((Supplier<ISpell>)Spells.SPIT_METAL, 10, 12).finish();
    }

    public static SpellTree airTree() {
        return SpellTree.builder(SpellsUtil.generateUUIDForTree("movement"), Spells.JUMP_BOOST, 15, 12, (Component)Component.m_237115_((String)KEY_MOVEMENT)).icon((ISpell)Spells.JUMP_BOOST.get()).add((Supplier<ISpell>)Spells.LEAP, 10, 14).add((Supplier<ISpell>)Spells.SPEED, 20, 20).leaf().add((Supplier<ISpell>)Spells.JUMP, 14, 14).leaf().leaf().add((Supplier<ISpell>)Spells.MANA_SOLES, 15, 12).add((Supplier<ISpell>)Spells.SLOW_FALLING, 15, 16).leaf().leaf().add((Supplier<ISpell>)Spells.BLOW_ARROW, 10, 16).add((Supplier<ISpell>)Spells.PRESSURIZE, 20, 18).leaf().leaf().finish();
    }

    public static void readOrWriteSpellTreeConfigs() {
        List<SpellTree> baseTrees = SpellTrees.getBaseTrees();
        if (((Boolean)SpellsConfig.ADD_DEFAULT_SPELL_TREES.get()).booleanValue()) {
            LOADED_SPELL_TREES.addAll(baseTrees);
        }
        boolean makeConfigs = !SpellsFileUtil.doesSubConfigDirExist("spell_trees");
        Path p = SpellsFileUtil.getOrCreateSubConfigDir("spell_trees");
        File folder = p.toFile();
        if (!folder.isDirectory() || folder.listFiles() == null) {
            SpellsAndShields.LOGGER.error("Can not read or write spell tree files in {} (is it a folder?).", (Object)p);
            return;
        }
        if (((Boolean)SpellsConfig.CREATE_DEFAULT_SPELL_TREES.get()).booleanValue()) {
            SpellsConfig.CREATE_DEFAULT_SPELL_TREES.set((Object)false);
            SpellsConfig.CREATE_DEFAULT_SPELL_TREES.save();
            int i = 0;
            for (SpellTree t : baseTrees) {
                File f = p.resolve("tree_" + i++ + ".json").toFile();
                try {
                    SpellsFileUtil.writeJsonToFile(f, (JsonElement)SpellTreeSerializer.treeToJson(t));
                    SpellsAndShields.LOGGER.info("Wrote default spell tree {} to file {}.", (Object)t.getId(), (Object)f.toPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SpellsAndShields.LOGGER.error("Failed writing default spell tree {} to file {}.", (Object)t.getId().toString(), (Object)f.toPath(), (Object)e);
                }
            }
        }
        if (((Boolean)SpellsConfig.LOAD_SPELL_TREES.get()).booleanValue()) {
            for (File f : folder.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".json")) continue;
                boolean failed = false;
                JsonElement json = null;
                try {
                    json = SpellsFileUtil.readJsonFromFile(f);
                }
                catch (Exception e) {
                    failed = true;
                    SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath(), (Object)e);
                    e.printStackTrace();
                }
                if (json != null && json.isJsonObject()) {
                    SpellTree t = null;
                    try {
                        t = SpellTreeSerializer.treeFromJson(json.getAsJsonObject());
                        SpellsAndShields.LOGGER.info("Successfully read spell tree from file {}.", (Object)f.toPath());
                    }
                    catch (IllegalStateException e) {
                        SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath(), (Object)e);
                        e.printStackTrace();
                    }
                    if (t == null) continue;
                    LOADED_SPELL_TREES.add(t);
                    continue;
                }
                if (failed) continue;
                SpellsAndShields.LOGGER.error("Failed reading spell tree from file {}.", (Object)f.toPath());
            }
        }
    }

    private static void availableSpellTrees(AvailableSpellTreesEvent event) {
        LOADED_SPELL_TREES.forEach(tree -> event.addSpellTree(tree.copy()));
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(SpellTrees::availableSpellTrees);
    }
}

