/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.event.AvailableSpellTreesEvent;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ProgressionHelper {
    public static List<SpellTree> getStrippedSpellTrees(SpellProgressionHolder spellProgressionHolder, int bookshelves) {
        List<SpellTree> allAvailableSkillTrees = ProgressionHelper.getAllAvailableSpellTrees(spellProgressionHolder);
        LinkedList<SpellTree> strippedSkillTrees = new LinkedList<SpellTree>();
        for (SpellTree spellTree0 : allAvailableSkillTrees) {
            if (spellTree0.getRoot() == null || spellTree0.getRoot().getRequiredBookshelves() > bookshelves) continue;
            SpellTree stripped = spellTree0.copy();
            LinkedList<SpellNode> visibleNodes = new LinkedList<SpellNode>();
            stripped.forEach(spellNode -> {
                if (spellProgressionHolder.getSpellStatus(spellNode.getSpell()).isVisible()) {
                    visibleNodes.add((SpellNode)spellNode);
                }
            });
            if (!visibleNodes.contains(stripped.getRoot())) {
                visibleNodes.add(stripped.getRoot());
                if (visibleNodes.size() == 1) {
                    stripped.getRoot().getChildren().clear();
                    strippedSkillTrees.add(stripped);
                    continue;
                }
            }
            for (SpellNode spellNode2 : visibleNodes.stream().toList()) {
                SpellNode parent;
                while ((parent = spellNode2.getParent()) != null && !visibleNodes.contains(parent)) {
                    visibleNodes.add(parent);
                    spellNode2 = parent;
                }
            }
            LinkedList invisibleNodes = new LinkedList();
            stripped.forEach(spellNode -> {
                if (!visibleNodes.contains(spellNode)) {
                    boolean fullyLinked = ProgressionHelper.isFullyLinked(spellNode, spellProgressionHolder.getProgression());
                    if (fullyLinked) {
                        spellNode.getChildren().clear();
                    } else {
                        invisibleNodes.add(spellNode);
                    }
                }
            });
            invisibleNodes.forEach(spellNode -> spellNode.getParent().getChildren().remove(spellNode));
            strippedSkillTrees.add(stripped);
        }
        return strippedSkillTrees;
    }

    public static List<SpellTree> getStrippedSpellTrees(SpellProgressionHolder spellProgressionHolder, BlockPos enchantTable) {
        List<SpellTree> availableSpellTrees = ProgressionHelper.getStrippedSpellTrees(spellProgressionHolder, SpellProgressionMenu.getSurroundingEnchantingPower(spellProgressionHolder.getPlayer().f_19853_, enchantTable));
        HashMap cheapestCosts = new HashMap();
        for (SpellTree spellTree : availableSpellTrees) {
            spellTree.forEach(spellNode -> cheapestCosts.put(spellNode.getSpell(), Math.min(spellNode.getLevelCost(), cheapestCosts.getOrDefault(spellNode.getSpell(), Integer.MAX_VALUE))));
        }
        for (SpellTree spellTree : availableSpellTrees) {
            spellTree.forEach(spellNode -> spellNode.setLevelCost(cheapestCosts.getOrDefault(spellNode.getSpell(), spellNode.getLevelCost())));
        }
        return availableSpellTrees;
    }

    public static List<SpellTree> getAllAvailableSpellTrees(SpellProgressionHolder spellProgressionHolder) {
        LinkedList<SpellTree> availableSpellTrees = new LinkedList<SpellTree>();
        AvailableSpellTreesEvent event = new AvailableSpellTreesEvent(spellProgressionHolder.getPlayer(), spellProgressionHolder, availableSpellTrees);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return availableSpellTrees;
    }

    public static boolean isFullyLinked(SpellNode spellNode, Map<ISpell, SpellStatus> progression) {
        SpellNode parent = spellNode;
        while ((parent = parent.getParent()) != null) {
            if (progression.getOrDefault(parent.getSpell(), SpellStatus.LOCKED).isAvailable()) continue;
            return false;
        }
        return true;
    }

    public static boolean tryBuySpell(SpellProgressionMenu menu, ISpell spell, UUID id) {
        return (Boolean)menu.access.m_39299_((level, blockPos) -> ProgressionHelper.tryBuySpell(menu, spell, SpellProgressionMenu.getSurroundingEnchantingPower(level, blockPos), id), (Object)false);
    }

    public static boolean tryBuySpell(SpellProgressionMenu menu, ISpell spell, int availableBookshelves, UUID id) {
        Player player = menu.player;
        AtomicBoolean found = new AtomicBoolean(false);
        menu.spellTrees.stream().filter(tree -> tree.getId().equals(id)).findFirst().ifPresent(spellTree -> spellTree.forEach(spellNode -> {
            if (!found.get() && spellNode.getSpell() == spell && spellNode.getRequiredBookshelves() <= availableBookshelves && (player.f_36078_ >= spellNode.getLevelCost() || player.m_7500_())) {
                found.set(true);
                player.m_6749_(-spellNode.getLevelCost());
            }
        }));
        return found.get();
    }
}

