/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells;

import com.google.gson.JsonElement;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.spell.IConfigurableSpell;
import de.cas_ual_ty.spells.spell.IEventSpell;
import de.cas_ual_ty.spells.spell.ISingletonTickSpell;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spell.IStackedTickSpell;
import de.cas_ual_ty.spells.spell.ITickSpell;
import de.cas_ual_ty.spells.spell.base.AttributeSpell;
import de.cas_ual_ty.spells.spell.base.MobEffectSpell;
import de.cas_ual_ty.spells.spell.impl.AquaAffinitySpell;
import de.cas_ual_ty.spells.spell.impl.BlowArrowSpell;
import de.cas_ual_ty.spells.spell.impl.FireBallSpell;
import de.cas_ual_ty.spells.spell.impl.FireChargeSpell;
import de.cas_ual_ty.spells.spell.impl.InstantMineSpell;
import de.cas_ual_ty.spells.spell.impl.JumpSpell;
import de.cas_ual_ty.spells.spell.impl.LeapSpell;
import de.cas_ual_ty.spells.spell.impl.ManaSolesSpell;
import de.cas_ual_ty.spells.spell.impl.PotionShotSpell;
import de.cas_ual_ty.spells.spell.impl.PressurizeSpell;
import de.cas_ual_ty.spells.spell.impl.SmeltSpell;
import de.cas_ual_ty.spells.spell.impl.SpitMetalSpell;
import de.cas_ual_ty.spells.spell.impl.SummonAnimalSpell;
import de.cas_ual_ty.spells.spell.impl.TransferManaSpell;
import de.cas_ual_ty.spells.spell.impl.WalkerSpell;
import de.cas_ual_ty.spells.spell.impl.WaterLeapSpell;
import de.cas_ual_ty.spells.spell.impl.WaterWhipSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class Spells {
    public static Supplier<IForgeRegistry<ISpell>> SPELLS_REGISTRY;
    private static final DeferredRegister<ISpell> SPELLS;
    public static final RegistryObject<ISpell> SPIT_METAL;
    public static final RegistryObject<ISpell> FIRE_RESISTANCE;
    public static final RegistryObject<ISpell> INSTANT_MINE;
    public static final RegistryObject<ISpell> PRESSURIZE;
    public static final RegistryObject<ISpell> FIRE_CHARGE;
    public static final RegistryObject<ISpell> MANA_SOLES;
    public static final RegistryObject<ISpell> JUMP;
    public static final RegistryObject<ISpell> FROST_WALKER;
    public static final RegistryObject<ISpell> POTION_SHOT;
    public static final RegistryObject<ISpell> WATER_WHIP;
    public static final RegistryObject<ISpell> REPLENISHMENT;
    public static final RegistryObject<ISpell> REGENERATION;
    public static final RegistryObject<ISpell> HASTE;
    public static final RegistryObject<ISpell> SLOW_FALLING;
    public static final RegistryObject<ISpell> WATER_BREATHING;
    public static final RegistryObject<ISpell> AQUA_AFFINITY;
    public static final RegistryObject<ISpell> WATER_LEAP;
    public static final RegistryObject<ISpell> DOLPHINS_GRACE;
    public static final RegistryObject<ISpell> JUMP_BOOST;
    public static final RegistryObject<ISpell> SPEED;
    public static final RegistryObject<ISpell> MANA_BOOST;
    public static final RegistryObject<ISpell> HEALTH_BOOST;
    public static final RegistryObject<ISpell> BLOW_ARROW;
    public static final RegistryObject<ISpell> TRANSFER_MANA;
    public static final RegistryObject<ISpell> BLAST_SMELT;
    public static final RegistryObject<ISpell> FIRE_BALL;
    public static final RegistryObject<ISpell> SUMMON_ANIMAL;
    public static final RegistryObject<ISpell> LEAP;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Spells::newRegistry);
        SPELLS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void newRegistry(NewRegistryEvent event) {
        SPELLS_REGISTRY = event.create(new RegistryBuilder().setMaxID(1024).setName(new ResourceLocation("spells_and_shields", "spells")));
    }

    public static void spellsConfigs() {
        Path p = SpellsFileUtil.getOrCreateSubConfigDir("spells");
        File folder = p.toFile();
        if (!folder.isDirectory() || folder.listFiles() == null) {
            SpellsAndShields.LOGGER.error("Can not read or write spell config files in {} (is it a folder?).", (Object)p);
            SPELLS_REGISTRY.get().getValues().stream().filter(s -> s instanceof IConfigurableSpell).map(s -> (IConfigurableSpell)s).forEach(IConfigurableSpell::applyDefaultConfig);
            return;
        }
        if (((Boolean)SpellsConfig.LOAD_SPELLS_CONFIGS.get()).booleanValue()) {
            SPELLS_REGISTRY.get().getEntries().stream().filter(e -> e.getValue() instanceof IConfigurableSpell).forEach(entry -> {
                ResourceLocation key;
                IConfigurableSpell spell = (IConfigurableSpell)entry.getValue();
                File f = p.resolve(spell.getFileName(key = ((ResourceKey)entry.getKey()).m_135782_()) + ".json").toFile();
                if (!f.exists()) {
                    if (((Boolean)SpellsConfig.CREATE_SPELLS_CONFIGS.get()).booleanValue()) {
                        try {
                            SpellsFileUtil.writeJsonToFile(f, (JsonElement)spell.makeDefaultConfig());
                            SpellsAndShields.LOGGER.info("Successfully wrote default config of spell {} to file {}.", (Object)key.toString(), (Object)f.toPath());
                        }
                        catch (Exception e) {
                            SpellsAndShields.LOGGER.error("Failed writing default config of spell {} to file {}.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                            e.printStackTrace();
                        }
                    }
                    spell.applyDefaultConfig();
                } else {
                    boolean failed = false;
                    JsonElement json = null;
                    try {
                        json = SpellsFileUtil.readJsonFromFile(f);
                    }
                    catch (Exception e) {
                        failed = true;
                        SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                        e.printStackTrace();
                        spell.applyDefaultConfig();
                    }
                    if (json != null && json.isJsonObject()) {
                        try {
                            spell.readFromConfig(json.getAsJsonObject());
                            SpellsAndShields.LOGGER.info("Successfully read config of spell {} from file {}.", (Object)key.toString(), (Object)f.toPath());
                        }
                        catch (IllegalStateException e) {
                            SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath(), (Object)e);
                            e.printStackTrace();
                            spell.applyDefaultConfig();
                        }
                    } else if (!failed) {
                        SpellsAndShields.LOGGER.error("Failed reading config of spell {} from file {}, applying default config.", (Object)key.toString(), (Object)f.toPath());
                        spell.applyDefaultConfig();
                    }
                }
            });
        } else {
            SPELLS_REGISTRY.get().getValues().stream().filter(s -> s instanceof IConfigurableSpell).map(s -> (IConfigurableSpell)s).forEach(IConfigurableSpell::applyDefaultConfig);
        }
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            SpellHolder.getSpellHolder(event.player).ifPresent(spellHolder -> {
                ISpell spell;
                int i;
                LinkedList<Integer> idx = new LinkedList<Integer>();
                for (i = 0; i < 5; ++i) {
                    idx.addLast(i);
                }
                while (!idx.isEmpty()) {
                    i = (Integer)idx.removeFirst();
                    ISpell patt10576$temp = spellHolder.getSpell(i);
                    if (!(patt10576$temp instanceof ITickSpell)) continue;
                    spell = (ITickSpell)patt10576$temp;
                    int amount = 1;
                    for (int j = i + 1; j < 5; ++j) {
                        if (spellHolder.getSpell(j) != spell) continue;
                        idx.removeFirstOccurrence(j);
                        ++amount;
                    }
                    spell.tick((SpellHolder)spellHolder, amount);
                }
                for (i = 0; i < 5; ++i) {
                    ISpell patt11338$temp = spellHolder.getSpell(i);
                    if (!(patt11338$temp instanceof IStackedTickSpell)) continue;
                    spell = (IStackedTickSpell)patt11338$temp;
                    spell.tick((SpellHolder)spellHolder, i);
                }
            });
        }
    }

    private static void tick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            SPELLS_REGISTRY.get().forEach(s -> {
                if (s instanceof ISingletonTickSpell) {
                    ISingletonTickSpell spell = (ISingletonTickSpell)s;
                    spell.tickSingleton();
                }
            });
        }
    }

    public static void registerEventSpells() {
        SPELLS_REGISTRY.get().forEach(spell -> {
            if (spell instanceof IEventSpell) {
                IEventSpell eventSpell = (IEventSpell)spell;
                eventSpell.registerEvents();
            }
        });
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(Spells::playerTick);
        MinecraftForge.EVENT_BUS.addListener(Spells::tick);
    }

    static {
        SPELLS = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "spells"), (String)"spells_and_shields");
        SPIT_METAL = SPELLS.register("spit_metal", () -> new SpitMetalSpell(4.0f));
        FIRE_RESISTANCE = SPELLS.register("fire_resistance", () -> new MobEffectSpell(MobEffects.f_19607_));
        INSTANT_MINE = SPELLS.register("instant_mine", () -> new InstantMineSpell(5.0f));
        PRESSURIZE = SPELLS.register("pressurize", () -> new PressurizeSpell(4.0f));
        FIRE_CHARGE = SPELLS.register("fire_charge", () -> new FireChargeSpell(4.0f, new ItemStack((ItemLike)Items.f_42613_)).setSmallIcon(new ResourceLocation("textures/item/fire_charge.png")));
        MANA_SOLES = SPELLS.register("mana_soles", () -> new ManaSolesSpell());
        JUMP = SPELLS.register("jump", () -> new JumpSpell(5.0f));
        FROST_WALKER = SPELLS.register("frost_walker", () -> new WalkerSpell());
        POTION_SHOT = SPELLS.register("potion_shot", () -> new PotionShotSpell(2.0f).setSmallIcon(new ResourceLocation("textures/item/potion.png")));
        WATER_WHIP = SPELLS.register("water_whip", () -> new WaterWhipSpell(2.0f));
        REPLENISHMENT = SPELLS.register("replenishment", () -> new MobEffectSpell((MobEffect)SpellsRegistries.REPLENISHMENT_EFFECT.get(), 50));
        REGENERATION = SPELLS.register("regeneration", () -> new MobEffectSpell(MobEffects.f_19605_, 50));
        HASTE = SPELLS.register("haste", () -> new MobEffectSpell(MobEffects.f_19598_));
        SLOW_FALLING = SPELLS.register("slow_falling", () -> new MobEffectSpell(MobEffects.f_19591_));
        WATER_BREATHING = SPELLS.register("water_breathing", () -> new MobEffectSpell(MobEffects.f_19608_));
        AQUA_AFFINITY = SPELLS.register("aqua_affinity", () -> new AquaAffinitySpell().setSmallIcon(new ResourceLocation("textures/item/enchanted_book.png")));
        WATER_LEAP = SPELLS.register("water_leap", () -> new WaterLeapSpell(7.0f));
        DOLPHINS_GRACE = SPELLS.register("dolphins_grace", () -> new MobEffectSpell(MobEffects.f_19593_));
        JUMP_BOOST = SPELLS.register("jump_boost", () -> new MobEffectSpell(MobEffects.f_19603_));
        SPEED = SPELLS.register("speed", () -> new MobEffectSpell(MobEffects.f_19596_));
        MANA_BOOST = SPELLS.register("mana_boost", () -> new AttributeSpell(() -> SpellsRegistries.MAX_MANA_ATTRIBUTE.get(), 4.0, AttributeModifier.Operation.ADDITION).setIcon(new ResourceLocation("spells_and_shields", "textures/mob_effect/mana_boost.png")));
        HEALTH_BOOST = SPELLS.register("health_boost", () -> new AttributeSpell(() -> Attributes.f_22276_, 4.0, AttributeModifier.Operation.ADDITION).setIcon(new ResourceLocation("textures/mob_effect/health_boost.png")));
        BLOW_ARROW = SPELLS.register("blow_arrow", () -> new BlowArrowSpell(7.0f));
        TRANSFER_MANA = SPELLS.register("transfer_mana", () -> new TransferManaSpell(4.0f));
        BLAST_SMELT = SPELLS.register("blast_smelt", () -> new SmeltSpell(6.0f));
        FIRE_BALL = SPELLS.register("fire_ball", () -> new FireBallSpell(5.0f));
        SUMMON_ANIMAL = SPELLS.register("summon_animal", () -> new SummonAnimalSpell(18.0f));
        LEAP = SPELLS.register("leap", () -> new LeapSpell(7.0f));
    }
}

