/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.client.ManaClientTooltipComponent;
import de.cas_ual_ty.spells.client.ManaRenderer;
import de.cas_ual_ty.spells.client.SpellKeyBindings;
import de.cas_ual_ty.spells.client.SpellsClientConfig;
import de.cas_ual_ty.spells.client.progression.SpellInteractButton;
import de.cas_ual_ty.spells.client.progression.SpellProgressionScreen;
import de.cas_ual_ty.spells.client.progression.SpellSlotWidget;
import de.cas_ual_ty.spells.network.RequestSpellProgressionMenuMessage;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.spell.base.HomingSpellProjectile;
import de.cas_ual_ty.spells.spell.base.SpellProjectile;
import de.cas_ual_ty.spells.util.ManaTooltipComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;

public class SpellsClientUtil {
    private static BlockPos lastRightClickedBlockPos = null;
    private static Block lastRightClickedBlock = null;
    private static List<SpellSlotWidget> spellSlotWidgets = new ArrayList<SpellSlotWidget>(5);

    public static void onModConstruct() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SpellsClientConfig.CLIENT_SPEC, "spells_and_shields/client.toml");
        SpellKeyBindings.register();
        ManaRenderer.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsClientUtil::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsClientUtil::entityRenderers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsClientUtil::registerClientTooltipComponent);
        MinecraftForge.EVENT_BUS.addListener(SpellsClientUtil::rightClickBlock);
        MinecraftForge.EVENT_BUS.addListener(SpellsClientUtil::initScreen);
        MinecraftForge.EVENT_BUS.addListener(SpellsClientUtil::renderScreen);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)SpellsRegistries.SPELL_PROGRESSION_MENU.get()), SpellProgressionScreen::new);
    }

    private static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SpellsRegistries.SPELL_PROJECTILE.get(), context -> new EntityRenderer<SpellProjectile>(context){

            public ResourceLocation getTextureLocation(SpellProjectile pEntity) {
                return null;
            }
        });
        event.registerEntityRenderer((EntityType)SpellsRegistries.HOMING_SPELL_PROJECTILE.get(), context -> new EntityRenderer<HomingSpellProjectile>(context){

            public ResourceLocation getTextureLocation(HomingSpellProjectile pEntity) {
                return null;
            }
        });
    }

    private static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        lastRightClickedBlockPos = event.getPos();
        lastRightClickedBlock = event.getEntity().f_19853_.m_8055_(event.getPos()).m_60734_();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void initScreen(ScreenEvent.Init.Post event) {
        if (Minecraft.m_91087_().f_91074_ == null) return;
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (lastRightClickedBlock == SpellsRegistries.VANILLA_ENCHANTING_TABLE.get()) {
                lastRightClickedBlock = null;
                event.addListener((GuiEventListener)new SpellInteractButton(screen2.getGuiLeft(), screen2.getGuiTop() - 26, Math.min(176, screen2.f_96543_), 26, SpellProgressionMenu.TITLE, b -> SpellsAndShields.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new RequestSpellProgressionMenuMessage(lastRightClickedBlockPos)), 0));
                return;
            }
        }
        if (!((screen = event.getScreen()) instanceof InventoryScreen)) return;
        InventoryScreen screen3 = (InventoryScreen)screen;
        spellSlotWidgets.clear();
        RecipeBookComponent recipeBook = null;
        for (GuiEventListener l : event.getListenersList()) {
            RecipeBookComponent c;
            if (!(l instanceof RecipeBookComponent)) continue;
            recipeBook = c = (RecipeBookComponent)l;
        }
        RecipeBookComponent finalRecipeBook = recipeBook;
        final BooleanSupplier isVisible = finalRecipeBook != null ? () -> !finalRecipeBook.m_100385_() : () -> true;
        int i = 0;
        while (i < 5) {
            int x = screen3.getGuiLeft() - 26;
            int y = screen3.getGuiTop() + i * 27;
            int slot = i;
            SpellSlotWidget s = new SpellSlotWidget(x, y, i, j -> {}, (b, pS, mX, mY) -> SpellSlotWidget.spellSlotToolTip((Screen)screen3, pS, mX, mY, slot)){

                public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
                    this.f_93624_ = isVisible.getAsBoolean();
                    super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
                }
            };
            spellSlotWidgets.add(s);
            event.addListener((GuiEventListener)s);
            s.f_93623_ = false;
            ++i;
        }
    }

    private static void renderScreen(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            for (SpellSlotWidget s : spellSlotWidgets) {
                RenderSystem.m_69465_();
                s.m_7428_(event.getPoseStack(), event.getMouseX(), event.getMouseY());
                RenderSystem.m_69482_();
            }
        }
    }

    private static void registerClientTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ManaTooltipComponent.class, tooltip -> new ManaClientTooltipComponent(tooltip.mana));
    }

    public static LazyOptional<ManaHolder> getClientManaHolder() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            return ManaHolder.getManaHolder((LivingEntity)Minecraft.m_91087_().f_91074_);
        }
        return LazyOptional.empty();
    }
}

